<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us | Floracion Hospitality</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700;800&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>
    
    <style>
        body { font-family: 'Inter', sans-serif; }
        /* Style for the word-reveal animation spans */
        .js-animated-title span { display: inline-block; }
        .js-animated-title span > span { transform: translateY(-100%); }
    </style>
</head>
<body class="bg-white">

    <?php 
    // Include the shared navigation bar
    include 'navbar.php'; 

    // --- PHP Data for Team Members ---
    $teamMembers = [
        ['name' => 'Alex Johnson', 'role' => 'Founder & CEO', 'image' => 'https://images.unsplash.com/photo-1599566150163-29194dcaad36?q=80&w=2787&auto=format&fit=crop'],
        ['name' => 'Maria Garcia', 'role' => 'Head of Operations', 'image' => 'https://images.unsplash.com/photo-1580489944761-15a19d654956?q=80&w=2861&auto=format&fit=crop'],
        ['name' => 'Chen Wei', 'role' => 'Director of Marketing', 'image' => 'https://images.unsplash.com/photo-1542596594-649edbbb66a6?q=80&w=2787&auto=format&fit=crop'],
    ];
    ?>

    <main id="about-page" class="text-gray-800 font-sans overflow-x-hidden">

        <section class="relative h-screen w-full flex items-center justify-center text-white text-center overflow-hidden">
            <video autoPlay loop muted playsInline class="absolute z-0 w-auto min-w-full min-h-full max-w-none object-cover">
                <source src="assets/property4.mp4" type="video/mp4" />
                Your browser does not support the video tag.
            </video>
            <div class="absolute inset-0 bg-black/70"></div>
            <div class="relative z-10 p-6">
                <h1 data-aos="zoom-in" class="text-4xl md:text-6xl lg:text-7xl font-bold tracking-tight">Blending Comfort With Elegance.</h1>
            </div>
        </section>

        <section class="story-section bg-white py-20 md:py-32 overflow-hidden">
            <div class="container mx-auto px-6 flex flex-col lg:flex-row gap-12 md:gap-16 items-center">
                <div class="text-content lg:w-1/2" data-aos="fade-right">
                    <h2 class="js-animated-title text-4xl md:text-5xl font-medium leading-tight mb-6">Our Story</h2>
                    <p class="text-gray-600 leading-relaxed mb-4">
                        Floracion Hospitality was born from a simple yet powerful idea: to bring a fresh, elegant, and deeply personal perspective to travel. We saw a world of standardized stays and envisioned a collection of properties where every detail matters, where comfort meets impeccable care.
                    </p>
                    <p class="text-gray-600 leading-relaxed">
                        We specialize in owning, leasing, and managing a curated portfolio of hotels, resorts, and homestays that are more than just places to sleep—they are destinations in themselves.
                    </p>
                </div>
                <div class="w-full lg:w-1/2 h-[350px] md:h-[500px] lg:h-[600px] rounded-2xl overflow-hidden" data-aos="fade-left">
                     <div class="story-image w-full h-full bg-cover bg-center" style="background-image: url(https://images.unsplash.com/photo-1540541338287-41700207dee6?q=80&w=2940&auto=format&fit=crop)"></div>
                </div>
            </div>
        </section>

        <section class="bg-gray-50 py-20 md:py-32">
            <div class="container mx-auto px-6 grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-12 text-center">
                <div class="mission-item p-8 bg-white rounded-2xl shadow-lg" data-aos="fade-up" data-aos-delay="0">
                    <svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="text-5xl text-green-500 mx-auto mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M9 18H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4"></path><path d="m13 22-5-5 5-5"></path><path d="M15 6h4a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-4"></path><path d="m11 2 5 5-5 5"></path></svg>
                    <h3 class="text-2xl font-semibold mb-3">Our Mission</h3>
                    <p class="text-gray-600">To create unforgettable lodging experiences by blending exceptional properties with unparalleled hospitality and service.</p>
                </div>
                <div class="mission-item p-8 bg-white rounded-2xl shadow-lg" data-aos="fade-up" data-aos-delay="100">
                    <svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="text-5xl text-green-500 mx-auto mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                    <h3 class="text-2xl font-semibold mb-3">Our Vision</h3>
                    <p class="text-gray-600">To be the most trusted and sought-after partner for property owners and travelers seeking unique and memorable stays.</p>
                </div>
                <div class="mission-item p-8 bg-white rounded-2xl shadow-lg" data-aos="fade-up" data-aos-delay="200">
                     <svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="text-5xl text-green-500 mx-auto mb-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M16 16.42A5.5 5.5 0 0 0 18 8h-1.26A5.5 5.5 0 0 0 8 8H6.74A5.5 5.5 0 0 0 8 16.42"></path><path d="M8 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path><path d="M16 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path><path d="M12 10a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path><path d="m12 14 1 2h-2l1-2z"></path><path d="M8.5 18a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path><path d="M15.5 18a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path></svg>
                    <h3 class="text-2xl font-semibold mb-3">Our Values</h3>
                    <p class="text-gray-600">Excellence, Transparency, Partnership, and a relentless commitment to guest satisfaction form the core of our identity.</p>
                </div>
            </div>
        </section>

        <section id="stats-section" class="bg-gray-900 text-white py-20">
            <div class="container mx-auto px-6 grid grid-cols-2 lg:grid-cols-4 gap-8 text-center">
                <div data-aos="zoom-in">
                    <span class="stat-number text-5xl md:text-6xl font-bold">50</span><span class="text-green-400 text-4xl">+</span>
                    <p class="text-white/70 mt-2">Premium Properties</p>
                </div>
                <div data-aos="zoom-in" data-aos-delay="100">
                    <span class="stat-number text-5xl md:text-6xl font-bold">15</span><span class="text-green-400 text-4xl">+</span>
                    <p class="text-white/70 mt-2">Stunning Locations</p>
                </div>
                <div data-aos="zoom-in" data-aos-delay="200">
                    <span class="stat-number text-5xl md:text-6xl font-bold">98</span><span class="text-green-400 text-4xl">%</span>
                    <p class="text-white/70 mt-2">Guest Satisfaction</p>
                </div>
                <div data-aos="zoom-in" data-aos-delay="300">
                    <span class="stat-number text-5xl md:text-6xl font-bold">1000</span><span class="text-green-400 text-4xl">+</span>
                    <p class="text-white/70 mt-2">Happy Guests</p>
                </div>
            </div>
        </section>

        <!-- <section class="bg-white py-20 md:py-32">
            <div class="container mx-auto px-6">
                <h2 class="js-animated-title text-4xl md:text-5xl font-medium text-center mb-12 md:mb-16">Meet the Leadership</h2>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
                    <?php foreach ($teamMembers as $index => $member): ?>
                        <div class="team-card text-center group" data-aos="fade-up" data-aos-delay="<?php echo $index * 100; ?>">
                            <div class="relative w-full h-[400px] rounded-2xl overflow-hidden mx-auto shadow-xl transform transition-all duration-500 group-hover:scale-105 group-hover:shadow-2xl">
                                <div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 ease-in-out group-hover:scale-110" style="background-image: url('<?php echo htmlspecialchars($member['image']); ?>')"></div>
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
                            </div>
                            <div class="mt-4">
                                <h3 class="text-2xl font-bold"><?php echo htmlspecialchars($member['name']); ?></h3>
                                <p class="text-gray-500"><?php echo htmlspecialchars($member['role']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section> -->

        <section class="bg-gray-100 text-center py-20 md:py-32">
            <div class="container mx-auto px-6" data-aos="zoom-in-up">
                <h2 class="js-animated-title text-4xl md:text-5xl font-medium mb-4 text-gray-900">Partner With Us</h2>
                <p class="max-w-2xl mx-auto text-base md:text-lg text-gray-600 mb-8">
                    Are you a property owner looking to unlock your property’s full potential? Let’s work together to turn your space into a thriving business.
                </p>
                <button class="bg-green-600 text-white font-bold px-8 py-3 md:px-10 md:py-4 rounded-full text-lg group hover:bg-green-700 transition-all duration-300 transform hover:scale-105">
                    Get In Touch <svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="inline-block transition-transform duration-300 group-hover:translate-x-1" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>
                </button>
            </div>
        </section>

    </main>
    
    <?php 
    // Include the shared footer
    include 'footer.php'; 
    ?>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <script>
    document.addEventListener('DOMContentLoaded', () => {
        // --- Initialize Libraries ---
        window.scrollTo(0, 0);
        AOS.init({
            duration: 1000,
            once: true,
            mirror: false,
        });

        // --- Animated Title Function (Replaces React Component) ---
        function initAnimatedTitle(titleElement) {
            if (!titleElement) return;
            const text = titleElement.textContent;
            const words = text.split(" ");
            titleElement.innerHTML = words.map(word => `<span><span>${word}</span></span>`).join(" ");
            
            gsap.to(titleElement.querySelectorAll("span > span"), {
                y: 0,
                stagger: 0.1,
                duration: 1,
                ease: 'power3.out',
                scrollTrigger: {
                    trigger: titleElement,
                    start: 'top 90%',
                }
            });
        }
        
        // Find and initialize all animated titles on the page
        document.querySelectorAll('.js-animated-title').forEach(initAnimatedTitle);

        // --- GSAP Animations ---
        // Parallax for the story image
        gsap.to('.story-image', {
            backgroundPositionY: '80%',
            ease: 'none',
            scrollTrigger: {
                trigger: '.story-section',
                start: 'top bottom',
                end: 'bottom top',
                scrub: true,
            }
        });

        // Animated Counters
        const statsSection = document.querySelector('#stats-section');
        if (statsSection) {
            const counters = gsap.utils.toArray('.stat-number');
            if (counters.length > 0) {
                gsap.from(counters, {
                    textContent: 0,
                    duration: 2.5,
                    ease: 'power2.out',
                    snap: { textContent: 1 },
                    stagger: 0.2,
                    scrollTrigger: {
                        trigger: statsSection,
                        start: 'top 80%',
                    }
                });
            }
        }
    });
    </script>
</body>
</html>