<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
    header("location: ../index.php");
    exit;
}

require_once '../config/db.php';

$total_owners = 0;
$total_users = 0;
$active_properties = 0;
$total_bookings = 0;

$total_owners_res = $conn->query("SELECT COUNT(id) as count FROM owners");
if ($total_owners_res) {
    $total_owners = $total_owners_res->fetch_assoc()['count'];
}

// 2. Total Users
$total_users_res = $conn->query("SELECT COUNT(id) as count FROM users");
if ($total_users_res) {
    $total_users = $total_users_res->fetch_assoc()['count'];
}

// 3. Total Active Properties
$active_properties_res = $conn->query("SELECT COUNT(id) as count FROM properties WHERE status = 'active'");
if ($active_properties_res) {
    $active_properties = $active_properties_res->fetch_assoc()['count'];
}

// 4. Total Bookings
$total_bookings_res = $conn->query("SELECT COUNT(id) as count FROM bookings");
if ($total_bookings_res) {
    $total_bookings = $total_bookings_res->fetch_assoc()['count'];
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f1f5f9; }
        .font-serif { font-family: 'Playfair Display', serif; }
        .stat-card {
            transition: all 0.3s ease-in-out;
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.05), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 35px -8px rgba(0, 0, 0, 0.1), 0 8px 15px -8px rgba(0, 0, 0, 0.06);
        }
        .gsap-reveal-text { opacity: 0; transform: translateY(20px); }
    </style>
</head>
<body class="text-gray-800">

    <main class="admin-main-container p-4 sm:p-6 lg:p-8">
        <div class="container mx-auto">
            <header class="admin-header mb-12">
                <div class="gsap-reveal-text">
                    <h1 class="font-serif text-4xl md:text-5xl font-bold text-gray-900">Welcome, Admin!</h1>
                    <p class="text-gray-500 mt-2">Here's a snapshot of your platform's activity.</p>
                </div>
            </header>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 lg:gap-8">
                <div class="stat-card relative p-6 rounded-2xl overflow-hidden bg-gradient-to-br from-blue-500 to-blue-600 text-white" data-aos="fade-up">
                    <i class="fas fa-user-tie absolute -right-4 -bottom-4 text-8xl text-white/10 transform rotate-[-15deg]"></i>
                    <div class="relative z-10">
                        <p class="text-sm font-medium uppercase tracking-wider text-blue-200">Total Owners</p>
                        <p class="stat-number text-5xl font-bold mt-2" data-target="<?php echo $total_owners; ?>">0</p>
                    </div>
                </div>

                <div class="stat-card relative p-6 rounded-2xl overflow-hidden bg-gradient-to-br from-emerald-500 to-emerald-600 text-white" data-aos="fade-up" data-aos-delay="100">
                    <i class="fas fa-users absolute -right-4 -bottom-4 text-8xl text-white/10 transform rotate-[-15deg]"></i>
                    <div class="relative z-10">
                        <p class="text-sm font-medium uppercase tracking-wider text-emerald-200">Total Users</p>
                        <p class="stat-number text-5xl font-bold mt-2" data-target="<?php echo $total_users; ?>">0</p>
                    </div>
                </div>

                <div class="stat-card relative p-6 rounded-2xl overflow-hidden bg-gradient-to-br from-purple-500 to-purple-600 text-white" data-aos="fade-up" data-aos-delay="200">
                    <i class="fas fa-building absolute -right-4 -bottom-4 text-8xl text-white/10 transform rotate-[-15deg]"></i>
                    <div class="relative z-10">
                        <p class="text-sm font-medium uppercase tracking-wider text-purple-200">Active Properties</p>
                        <p class="stat-number text-5xl font-bold mt-2" data-target="<?php echo $active_properties; ?>">0</p>
                    </div>
                </div>

                <div class="stat-card relative p-6 rounded-2xl overflow-hidden bg-gradient-to-br from-amber-500 to-amber-600 text-white" data-aos="fade-up" data-aos-delay="300">
                    <i class="fas fa-calendar-check absolute -right-4 -bottom-4 text-8xl text-white/10 transform rotate-[-15deg]"></i>
                    <div class="relative z-10">
                        <p class="text-sm font-medium uppercase tracking-wider text-amber-200">Total Bookings</p>
                        <p class="stat-number text-5xl font-bold mt-2" data-target="<?php echo $total_bookings; ?>">0</p>
                    </div>
                </div>
            </div>

            </div>
    </main>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // --- Initialize AOS ---
            AOS.init({ once: true, duration: 800, easing: 'ease-in-out-cubic' });

            // --- GSAP Page Load Animations ---
            const tl = gsap.timeline({ defaults: { ease: 'power3.out' } });

            // Animate the header text
            tl.from('.gsap-reveal-text', { 
                opacity: 0, 
                y: 20, 
                duration: 1 
            });

            // Animate the stat numbers with a counting effect
            document.querySelectorAll('.stat-number').forEach(numberElement => {
                const target = parseInt(numberElement.dataset.target, 10);
                let counter = { value: 0 };

                tl.to(counter, {
                    value: target,
                    duration: 1.5,
                    ease: 'power2.out',
                    onUpdate: () => {
                        numberElement.textContent = Math.ceil(counter.value);
                    }
                }, "-=0.8"); // Start this animation slightly before the previous one ends
            });
        });
    </script>

</body>
</html>