<?php
// Admin Dashboard (index.php)
session_start();

// Authentication check
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

$admin_username = $_SESSION['admin_username'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Floracion - Admin Dashboard</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="icon" type="image/png" href="Assets/logo.png" />

    <style>
        /* --- SAME STYLES AS OWNER DASHBOARD, JUST CHANGED TITLE --- */
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500&display=swap');
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f7f6; 
            color: #333;
            overflow-x: hidden;
        }
        .container { display: flex; flex-direction: column; height: 100vh; }
        .navbar {
            background: #2c3e50; padding: 10px 20px; color: #fff;
            display: flex; align-items: center; justify-content: space-between;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1); flex-shrink: 0;
        }
        .navbar-icons { display: flex; align-items: center; gap: 20px; font-size: 20px; }
        .navbar-icons i { cursor: pointer; transition: color 0.3s ease; }
        .navbar-icons i:hover { color: #1abc9c; }
        .main { display: flex; flex: 1; overflow: hidden; }
        .sidebar {
            width: 260px; background: #1f2d3d; color: #fff; display: flex; flex-direction: column;
            transition: width 0.3s ease; box-shadow: 2px 0 5px rgba(0,0,0,0.1);
            flex-shrink: 0; overflow-y: auto; scrollbar-width: none;
        }
        .sidebar::-webkit-scrollbar { display: none; }
        .sidebar.collapsed { width: 70px; min-width: 70px; }
        .sidebar-header {
            text-align: center; font-size: 20px; font-weight: 600;
            padding: 20px; background: #17212b;
        }
        .sidebar-menu { list-style: none; padding: 10px 0; flex-grow: 1; }
        .sidebar-menu li {
            padding: 15px 25px; display: flex; align-items: center; gap: 15px;
            cursor: pointer; color: #eaeaea; white-space: nowrap;
            transition: background 0.3s, color 0.3s;
        }
        .sidebar-menu li:hover:not(.active) { background: #34495e; }
        .sidebar-menu li.active {
            background-color: #34495e; border-left: 4px solid #1abc9c;
        }
        .sidebar-menu i { width: 25px; text-align: center; font-size: 16px; color: #95a5a6; }
        .sidebar-menu li:hover i, .sidebar-menu li.active i { color: #1abc9c; }
        .content { flex: 1; background: #fdfbf5; overflow-y: auto; }
        .content iframe { border: none; width: 100%; height: 100%; }
        .toggle-btn { background: none; border: none; font-size: 24px; cursor: pointer; color: #fff; }
        .sidebar-menu a {
            background-color: #e74c3c; color: #fff; padding: 8px 16px;
            border-radius: 6px; margin: 10px auto; font-size: 15px; text-decoration: none;
            display: flex; align-items: center; justify-content: center; width: 80%;
        }
        .sidebar-menu a:hover { background-color: #c0392b; }
    </style>
</head>
<body>
    <div class="container">
        <div class="navbar">
            <button class="toggle-btn" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>
            <div class="navbar-icons">
                <span>Welcome, <strong><?php echo htmlspecialchars($admin_username); ?></strong></span>
                <i class="fas fa-bell"></i>
                <i class="fas fa-envelope"></i>
                <i class="fas fa-user-circle"></i>
            </div>
        </div>

        <div class="main">
            <div class="sidebar" id="sidebar">
                <div class="sidebar-header">Admin Page</div>
               <ul class="sidebar-menu" id="sidebarMenu">
    <li onclick="loadPage(this, 'admin_dashboard.php')" class="active">
        <i class="fas fa-tachometer-alt"></i> <span>Dashboard</span>
    </li>
    <li onclick="loadPage(this, 'owner_req.php')">
        <i class="fas fa-user-check"></i> <span>Owner Approvals</span>
    </li>
    <li onclick="loadPage(this, 'all_bookings.php')">
        <i class="fas fa-calendar-check"></i> <span>All Bookings</span>
    </li>
    <li onclick="loadPage(this, 'upload_hero.php')">
        <i class="fas fa-images"></i> <span>Site Customization</span>
    </li>
    <li>
        <a href="admin_logout.php"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></a>
    </li>
</ul>

            </div>
            <div class="content">
                <iframe id="contentFrame" src="admin_dashboard.php"></iframe>
            </div>
        </div>
    </div>

<script>
    function toggleSidebar() {
        document.getElementById('sidebar').classList.toggle('collapsed');
    }
    function loadPage(el, page) {
        document.getElementById('contentFrame').src = page;
        document.querySelectorAll('#sidebarMenu li').forEach(item => item.classList.remove('active'));
        el.classList.add('active');
    }
</script>
</body>
</html>
