<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - Floracion Hospitality</title>

    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- AOS (Animate on Scroll) Library -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <!-- Google Fonts: Cormorant Garamond (Serif) & Inter (Sans-serif) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@400;500;600;700&family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">

    <!-- React Icons are not directly usable, so we'll use an icon library like Remix Icon -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.2.0/fonts/remixicon.css" rel="stylesheet" />

    <!-- Custom Styles -->
    <style>
        .landingpagecontainer-font-serif {
            font-family: 'Cormorant Garamond', serif;
        }
        .contact-form-input {
            width: 100%;
            padding: 1rem 1.25rem;
            background-color: #F8F7F2;
            border-radius: 0.75rem; /* 12px */
            border: 1px solid #DCD9D4; /* Light gray border */
            color: #1a1a1a;
            transition: all 0.3s ease;
            font-size: 1rem;
        }
        .contact-form-input::placeholder {
            color: #9ca3af; /* gray-400 */
        }
        .contact-form-input:focus {
            outline: none;
            background-color: #fff;
            border-color: #b48a5e; /* Amber-700 */
            box-shadow: 0 0 0 3px rgba(180, 138, 94, 0.2);
        }
        .contact-form-submit-button {
            background-color: #262626; /* Dark Gray */
            color: white;
            font-weight: 600;
            padding: 1rem 2.5rem;
            border-radius: 9999px;
            font-size: 1rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            border: 0;
            cursor: pointer;
        }
        .contact-form-submit-button:hover {
            background-color: #000;
            transform: scale(1.03);
            box-shadow: 0 10px 20px -10px rgba(0, 0, 0, 0.3);
        }
    </style>
</head>
    <?php include 'navbar.php'; ?>

<body class="bg-[#F8F7F2] text-gray-800 font-sans overflow-x-hidden">

    <div id="page-container">
        <!-- HERO SECTION -->
        <section class="contact-hero-section container mx-auto px-6 pt-32 md:pt-40 pb-20 md:pb-24 grid md:grid-cols-2 gap-12 items-center">
            <div class="text-left">
                <h1 class="text-5xl md:text-7xl font-medium landingpagecontainer-font-serif">
                    <div class="overflow-hidden py-1">
                        <div class="g-contact-line-child">Let's Create</div>
                    </div>
                    <div class="overflow-hidden py-1">
                        <div class="g-contact-line-child">Something</div>
                    </div>
                    <div class="overflow-hidden py-1">
                        <div class="g-contact-line-child text-amber-700/90">Exceptional.</div>
                    </div>
                </h1>
                <p class="g-contact-hero-p max-w-lg mt-6 text-lg text-gray-600 leading-relaxed">
                    Whether you're a property owner seeking a trusted partner or a guest looking for a memorable stay, we're here to help. Reach out and let's begin the conversation.
                </p>
            </div>
            <div class="g-contact-hero-image h-80 md:h-[60vh] rounded-2xl overflow-hidden">
                <img src="https://images.unsplash.com/photo-1551882547-ff40c63fe5fa?auto=format&fit=crop&w=1920&q=80" alt="Hotel reception with welcoming staff" class="w-full h-full object-cover"/>
            </div>
        </section>

        <!-- CONTACT FORM & INFO SECTION -->
        <section class="g-section container mx-auto px-6 py-20 md:py-24">
            <div class="bg-white/70 backdrop-blur-sm p-8 md:p-12 rounded-3xl shadow-lg grid lg:grid-cols-3 gap-12">
                <!-- Left Side: Info -->
                <div class="lg:col-span-1">
                    <h2 class="text-3xl md:text-4xl font-medium landingpagecontainer-font-serif">Contact Details</h2>
                    <p class="text-gray-600 mt-3">Find us here or drop us a line.</p>
                    
                    <div class="mt-10 space-y-6">
                        <a href="tel:+918971029884" class="flex items-center gap-4 group transition-colors duration-300">
                            <i class="ri-phone-line text-amber-700/90 text-xl"></i>
                            <span class="text-lg text-gray-700 group-hover:text-amber-700/90 font-medium">+91-8971029884</span>
                        </a>
                        <a href="mailto:floracionhospitality09@gmail.com" class="flex items-center gap-4 group transition-colors duration-300">
                            <i class="ri-mail-line text-amber-700/90 text-xl"></i>
                            <span class="text-lg text-gray-700 group-hover:text-amber-700/90 font-medium">floracionhospitality09@gmail.com</span>
                        </a>
                        <div class="flex items-start gap-4">
                            <i class="ri-map-pin-line text-amber-700/90 text-xl mt-1 flex-shrink-0"></i>
                            <span class="text-lg text-gray-700 font-medium">Bangalore, India</span>
                        </div>
                    </div>
                </div>

                <!-- Right Side: Form -->
                <div class="lg:col-span-2">
                    <form class="w-full space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <input type="text" placeholder="Your Name" class="contact-form-input" />
                            <input type="email" placeholder="Your Email" class="contact-form-input" />
                        </div>
                        <div>
                            <input type="text" placeholder="Subject (e.g., Property Inquiry)" class="contact-form-input" />
                        </div>
                        <div>
                            <textarea placeholder="Tell us about your property or question..." rows="5" class="contact-form-input resize-none"></textarea>
                        </div>
                        <div class="text-right">
                            <button type="submit" class="contact-form-submit-button group">
                                Send Message <i class="ri-arrow-right-line transition-transform duration-300 group-hover:translate-x-1"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </section>

        <!-- OUR PROCESS SECTION -->
        <section class="g-section container mx-auto px-6 py-20 md:py-24 text-center">
            <h2 class="text-4xl md:text-5xl font-medium landingpagecontainer-font-serif">Our Partnership Process</h2>
            <p class="max-w-3xl mx-auto mt-4 text-lg text-gray-600">A simple, transparent journey to unlock your property's full potential.</p>
            <div class="g-process-grid grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mt-16">
                <div class="g-process-card bg-white p-8 rounded-2xl text-left shadow-md hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                    <div class="text-white bg-amber-700/90 w-14 h-14 rounded-full flex items-center justify-center"><i class="ri-message-3-line text-2xl"></i></div>
                    <h3 class="text-xl font-bold text-gray-800 mt-6">Initial Consultation</h3>
                    <p class="text-gray-600 mt-2">We start with a friendly chat to understand your property, goals, and answer your initial questions.</p>
                </div>
                <div class="g-process-card bg-white p-8 rounded-2xl text-left shadow-md hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                    <div class="text-white bg-amber-700/90 w-14 h-14 rounded-full flex items-center justify-center"><i class="ri-briefcase-4-line text-2xl"></i></div>
                    <h3 class="text-xl font-bold text-gray-800 mt-6">Personalized Proposal</h3>
                    <p class="text-gray-600 mt-2">We provide a detailed, transparent proposal outlining our management strategy and projected returns.</p>
                </div>
                <div class="g-process-card bg-white p-8 rounded-2xl text-left shadow-md hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                    <div class="text-white bg-amber-700/90 w-14 h-14 rounded-full flex items-center justify-center"><i class="ri-check-double-line text-2xl"></i></div>
                    <h3 class="text-xl font-bold text-gray-800 mt-6">Effortless Onboarding</h3>
                    <p class="text-gray-600 mt-2">Our team handles everything, from professional photography and listing creation to getting your property guest-ready.</p>
                </div>
                <div class="g-process-card bg-white p-8 rounded-2xl text-left shadow-md hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                    <div class="text-white bg-amber-700/90 w-14 h-14 rounded-full flex items-center justify-center"><i class="ri-line-chart-line text-2xl"></i></div>
                    <h3 class="text-xl font-bold text-gray-800 mt-6">Launch & Optimize</h3>
                    <p class="text-gray-600 mt-2">We go live! Your property is marketed across top platforms while we continuously optimize pricing for maximum revenue.</p>
                </div>
            </div>
        </section>

        <!-- FAQ SECTION -->
        <section class="g-section bg-white py-20 md:py-24">
            <div class="container mx-auto px-6 max-w-4xl">
                <div class="text-center">
                    <h2 class="text-4xl md:text-5xl font-medium landingpagecontainer-font-serif">Frequently Asked Questions</h2>
                    <p class="max-w-3xl mx-auto mt-4 text-lg text-gray-600">Your questions, answered. Here are some common inquiries.</p>
                </div>
                <div class="g-faq-container mt-16">
                    <!-- FAQ Item 1 -->
                    <div class="contactpage-faq-item border-b border-gray-300/70 py-6 overflow-hidden">
                        <button class="faq-button w-full flex justify-between items-center text-left gap-4">
                            <h3 class="text-lg md:text-xl font-medium text-gray-800">What kind of properties do you manage?</h3>
                            <div class="flex-shrink-0 w-8 h-8 flex items-center justify-center">
                                <i class="faq-icon ri-arrow-down-s-line text-gray-500 text-2xl transition-transform duration-300"></i>
                            </div>
                        </button>
                        <div class="faq-answer grid transition-all duration-500 ease-in-out grid-rows-[0fr] opacity-0">
                            <div class="overflow-hidden">
                                <p class="text-gray-600 leading-relaxed pt-4">We specialize in managing premium vacation homes, luxury villas, boutique apartments, and unique stays in prime tourist destinations.</p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ Item 2 -->
                    <div class="contactpage-faq-item border-b border-gray-300/70 py-6 overflow-hidden">
                        <button class="faq-button w-full flex justify-between items-center text-left gap-4">
                            <h3 class="text-lg md:text-xl font-medium text-gray-800">How do you determine the rental price for my property?</h3>
                            <div class="flex-shrink-0 w-8 h-8 flex items-center justify-center">
                                <i class="faq-icon ri-arrow-down-s-line text-gray-500 text-2xl transition-transform duration-300"></i>
                            </div>
                        </button>
                        <div class="faq-answer grid transition-all duration-500 ease-in-out grid-rows-[0fr] opacity-0">
                            <div class="overflow-hidden">
                                <p class="text-gray-600 leading-relaxed pt-4">We use a sophisticated dynamic pricing model that analyzes market demand, seasonality, local events, and competitor rates in real-time to maximize your income and occupancy.</p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ Item 3 -->
                    <div class="contactpage-faq-item border-b border-gray-300/70 py-6 overflow-hidden">
                        <button class="faq-button w-full flex justify-between items-center text-left gap-4">
                            <h3 class="text-lg md:text-xl font-medium text-gray-800">What are your management fees?</h3>
                            <div class="flex-shrink-0 w-8 h-8 flex items-center justify-center">
                                <i class="faq-icon ri-arrow-down-s-line text-gray-500 text-2xl transition-transform duration-300"></i>
                            </div>
                        </button>
                        <div class="faq-answer grid transition-all duration-500 ease-in-out grid-rows-[0fr] opacity-0">
                            <div class="overflow-hidden">
                                <p class="text-gray-600 leading-relaxed pt-4">Our fees are competitive and performance-based, structured as a percentage of the booking revenue. This means we only make money when you do. Please contact us for a detailed proposal tailored to your property.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- MAP SECTION -->
        <section class="g-section container mx-auto px-6 py-20 md:py-24">
             <div class="rounded-3xl overflow-hidden shadow-2xl border-8 border-white">
                 <iframe 
                     src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d124416.3826922388!2d77.50130619726563!3d12.953959999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bae1670c9b44e6d%3A0xf8dfc3e8517e4fe4!2sBengaluru%2C%20Karnataka!5e0!3m2!1sen!2sin!4v1722982994960!5m2!1sen!2sin" 
                     width="100%" 
                     height="500" 
                     style="border: 0;" 
                     allowfullscreen="" 
                     loading="lazy" 
                     referrerpolicy="no-referrer-when-downgrade"
                     class="grayscale contrast-125 hover:grayscale-0 transition-all duration-500"
                 ></iframe>
             </div>
        </section>
    </div>

    <!-- GSAP (GreenSock Animation Platform) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <!-- AOS (Animate on Scroll) -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize AOS
            AOS.init({
                once: true,
                duration: 900,
                easing: 'ease-in-out',
            });

            // Register GSAP plugins
            gsap.registerPlugin(ScrollTrigger);

            // --- GSAP ANIMATIONS ---
            const scope = document.querySelector('#page-container');

            // Hero Animation
            const tl = gsap.timeline({ defaults: { ease: 'power4.out', duration: 1.5 } });
            tl.from('.g-contact-line-child', { y: '110%', stagger: 0.1, delay: 0.2 })
              .from('.g-contact-hero-p', { opacity: 0, y: 20 }, "-=0.8")
              .from('.g-contact-hero-image', { scale: 1.2, opacity: 0 }, "<");

            // Animate sections on scroll
            const sections = gsap.utils.toArray('.g-section');
            sections.forEach(section => {
                gsap.from(section, {
                    scrollTrigger: {
                        trigger: section,
                        start: 'top 85%',
                        toggleActions: 'play none none none',
                    },
                    opacity: 0,
                    y: 70,
                    duration: 1.2,
                    ease: 'power3.out',
                });
            });

            // Staggered card animations
            gsap.from('.g-process-card', {
                scrollTrigger: {
                    trigger: '.g-process-grid',
                    start: 'top 80%',
                },
                opacity: 0,
                y: 60,
                stagger: 0.2,
                duration: 0.8
            });
            
            gsap.from('.contactpage-faq-item', {
                scrollTrigger: {
                    trigger: '.g-faq-container',
                    start: 'top 80%',
                },
                opacity: 0,
                y: 40,
                stagger: 0.1,
                duration: 0.7
            });

            // --- FAQ Logic ---
            const faqItems = document.querySelectorAll('.contactpage-faq-item');
            faqItems.forEach((item, index) => {
                const button = item.querySelector('.faq-button');
                const answer = item.querySelector('.faq-answer');
                const icon = item.querySelector('.faq-icon');

                button.addEventListener('click', () => {
                    const isOpen = answer.classList.contains('grid-rows-[1fr]');

                    // Close all other items
                    faqItems.forEach((otherItem, otherIndex) => {
                        if (index !== otherIndex) {
                            const otherAnswer = otherItem.querySelector('.faq-answer');
                            const otherIcon = otherItem.querySelector('.faq-icon');
                            otherAnswer.classList.remove('grid-rows-[1fr]', 'opacity-100');
                            otherAnswer.classList.add('grid-rows-[0fr]', 'opacity-0');
                            otherIcon.classList.remove('rotate-180', 'text-amber-700');
                        }
                    });

                    // Toggle the clicked item
                    if (isOpen) {
                        answer.classList.remove('grid-rows-[1fr]', 'opacity-100');
                        answer.classList.add('grid-rows-[0fr]', 'opacity-0');
                        icon.classList.remove('rotate-180', 'text-amber-700');
                    } else {
                        answer.classList.remove('grid-rows-[0fr]', 'opacity-0');
                        answer.classList.add('grid-rows-[1fr]', 'opacity-100');
                        icon.classList.add('rotate-180', 'text-amber-700');
                    }
                });
            });
        });
    </script>
</body>
    <?php include 'Footer.php'; ?>

</html>
