<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <!-- Tailwind CSS -->
<script src="https://cdn.tailwindcss.com"></script>

<!-- GSAP & ScrollTrigger Plugin -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>
</head>
<body>
    <!--
    =======================================================================
    =========================== FOOTER SECTION ============================
    =======================================================================
-->
<footer id="footer-section" class="bg-gradient-to-br from-slate-900 to-black text-gray-300 pt-24 pb-8 px-4 sm:px-6 lg:px-8 relative overflow-hidden">
    <div class="container mx-auto relative z-10">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-16">

            <!-- Column 1: About Us -->
            <div class="footer-col">
                <h3 class="text-xl font-semibold text-white mb-4 border-b-2 border-green-400 pb-2 inline-block">Floracion Hospitality</h3>
                <p class="text-gray-400 leading-relaxed">
                    Specializing in owning, operating, and managing premium properties, we partner with owners for long-term success and provide guests with unforgettable stays.
                </p>
                <div class="flex space-x-4 mt-6">
                    <!-- Social Links -->
                    <a href="#" class="w-10 h-10 bg-gray-800 rounded-full flex items-center justify-center text-white hover:bg-green-500 hover:scale-110 transition-all duration-300">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 320 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path></svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-800 rounded-full flex items-center justify-center text-white hover:bg-green-500 hover:scale-110 transition-all duration-300">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path></svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-800 rounded-full flex items-center justify-center text-white hover:bg-green-500 hover:scale-110 transition-all duration-300">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8z"></path></svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-800 rounded-full flex items-center justify-center text-white hover:bg-green-500 hover:scale-110 transition-all duration-300">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 448 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path></svg>
                    </a>
                </div>
            </div>

            <!-- Column 2: Quick Links -->
            <div class="footer-col">
                <h3 class="text-xl font-semibold text-white mb-4 border-b-2 border-green-400 pb-2 inline-block">Quick Links</h3>
                <ul class="space-y-3">
                    <li><a href="#" class="hover:text-green-400 transition-colors duration-300 flex items-center gap-2 group"><svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="opacity-0 group-hover:opacity-100 transition-all duration-300 -translate-x-2 group-hover:translate-x-0" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg> Home</a></li>
                    <li><a href="#" class="hover:text-green-400 transition-colors duration-300 flex items-center gap-2 group"><svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="opacity-0 group-hover:opacity-100 transition-all duration-300 -translate-x-2 group-hover:translate-x-0" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg> About Us</a></li>
                    <li><a href="#" class="hover:text-green-400 transition-colors duration-300 flex items-center gap-2 group"><svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="opacity-0 group-hover:opacity-100 transition-all duration-300 -translate-x-2 group-hover:translate-x-0" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg> Services</a></li>
                    <li><a href="#" class="hover:text-green-400 transition-colors duration-300 flex items-center gap-2 group"><svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="opacity-0 group-hover:opacity-100 transition-all duration-300 -translate-x-2 group-hover:translate-x-0" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg> Properties</a></li>
                    <li><a href="#" class="hover:text-green-400 transition-colors duration-300 flex items-center gap-2 group"><svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="opacity-0 group-hover:opacity-100 transition-all duration-300 -translate-x-2 group-hover:translate-x-0" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg> Contact</a></li>
                </ul>
            </div>

            <!-- Column 3: Contact Info -->
            <div class="footer-col">
                <h3 class="text-xl font-semibold text-white mb-4 border-b-2 border-green-400 pb-2 inline-block">Contact Us</h3>
                <ul class="space-y-4 text-gray-400">
                    <li class="flex items-start gap-3">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 384 512" class="text-green-400 mt-1 flex-shrink-0" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M172.268 501.67C26.97 291.031 0 269.413 0 192 0 85.961 85.961 0 192 0s192 85.961 192 192c0 77.413-26.97 99.031-172.268 309.67a24 24 0 0 1-35.464 0zM192 272c44.183 0 80-35.817 80-80s-35.817-80-80-80-80 35.817-80 80 35.817 80 80 80z"></path></svg>
                        <span>Bangalore, Karnataka, India</span>
                    </li>
                    <li class="flex items-center gap-3">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="text-green-400" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"></path></svg>
                        <a href="mailto:floracionhospitality09@gmail.com" class="hover:text-green-400 transition-colors">floracionhospitality09@gmail.com</a>
                    </li>
                    <li class="flex items-center gap-3">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="text-green-400" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M493.4 24.6l-104-24.6c-15.2-3.6-30.5 4.2-39.7 16.4l-35.7 47.9c-9.2 12.3-11.4 28.3-5.5 42.4l33.5 79.4c3.4 8.1-.3 17.5-6.6 23.8L280 264.4c-11.2 11.2-25.6 18.7-42.2 20.9l-65.2 8.6c-16.9 2.2-31.8-9.2-34-26.1l-4.8-35.9c-.9-6.9-4.5-13.2-9.8-17.6l-47.4-39.5c-12.6-10.5-29.5-13-44.5-6.8L5.8 212.4c-15.2 6.3-24.7 22.3-24.7 39.1v104.4c0 26.5 21.5 48 48 48h273.1c24.2 0 46-17.7 51.2-41.2l60.3-265.3c4.2-18.5-6.1-36.8-23.7-42.2z"></path></svg>
                        <a href="tel:+918971029884" class="hover:text-green-400 transition-colors">+91-8971029884</a>
                    </li>
                </ul>
            </div>

            <!-- Column 4: Newsletter -->
            <div class="footer-col">
                <h3 class="text-xl font-semibold text-white mb-4 border-b-2 border-green-400 pb-2 inline-block">Stay Updated</h3>
                <p class="text-gray-400 mb-4">Subscribe to our newsletter for the latest deals and updates.</p>
                <form class="flex items-center relative">
                    <input type="email" placeholder="Your Email" class="w-full bg-gray-800 text-white px-4 py-3 rounded-l-md focus:outline-none focus:ring-2 focus:ring-green-500 transition-all" />
                    <button type="submit" class="bg-green-500 text-white px-4 py-3 rounded-r-md hover:bg-green-600 transition-colors">
                        <svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="24px" width="24px" xmlns="http://www.w3.org/2000/svg"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>
                    </button>
                </form>
            </div>
        </div>

        <!-- Bottom Copyright Section -->
        <div class="copyright-section border-t border-gray-700 pt-8 mt-8 text-center text-gray-500">
            <p>&copy; <?php echo date("Y"); ?> Floracion Hospitality. All Rights Reserved. Crafted with care.</p>
        </div>
    </div>
</footer>

<!--
    =======================================================================
    ====================== GSAP Animation Script ==========================
    =======================================================================
-->
<script>
document.addEventListener('DOMContentLoaded', () => {
    // Check if GSAP and ScrollTrigger are loaded
    if (typeof gsap !== 'undefined' && typeof ScrollTrigger !== 'undefined') {
        
        // Register the ScrollTrigger plugin
        gsap.registerPlugin(ScrollTrigger);

        const footerEl = document.querySelector('#footer-section');

        if (footerEl) {
            // --- Main Animation Timeline ---
            const tl = gsap.timeline({
                scrollTrigger: {
                    trigger: footerEl,
                    start: 'top 90%', // Start animation when the top of the footer is 90% from the top of the viewport
                    toggleActions: 'play none none reverse',
                }
            });

            // 1. Animate the entire footer container into view
            tl.from(footerEl, {
                y: 100,
                opacity: 0,
                duration: 1,
                ease: 'power3.out'
            });
            
            // 2. Animate the inner columns in a staggered sequence
            tl.from(footerEl.querySelectorAll('.footer-col'), {
                opacity: 0,
                y: 50,
                stagger: 0.2, // This creates the beautiful staggered effect
                duration: 0.8,
                ease: 'power3.out'
            }, "-=0.7"); // Overlap with the previous animation for a fluid effect

            // 3. Animate the copyright section at the end
            tl.from(footerEl.querySelector('.copyright-section'), {
                opacity: 0,
                y: 20,
                duration: 0.6,
                ease: 'power2.out'
            }, "-=0.5");
        }

    } else {
        console.error("GSAP or ScrollTrigger is not loaded. Please ensure the CDN scripts are included.");
    }
});
</script>
</body>
</html>