<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Floracion Hospitality – Where Hospitality Blooms</title>

    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- AOS (Animate on Scroll) Library -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <!-- Google Fonts: Cormorant Garamond (Serif) & Inter (Sans-serif) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@400;500;600;700&family=Inter:wght@300;400;500&display=swap" rel="stylesheet">

    <!-- Custom Styles -->
    <style>
        body {
            background-color: #F5F5F5; /* A gentle off-white */
            color: #1a1a1a;
            font-family: 'Inter', sans-serif;
            overflow-x: hidden;
        }

        .landingpagecontainer-font-serif {
            font-family: 'Cormorant Garamond', serif;
        }
        
        /* GSAP Text Reveal (for lines) */
        .landingpagecontainer-line-parent {
            overflow: hidden;
            padding: 2px 0;
        }
        .landingpagecontainer-line-child {
            transform: translateY(110%);
        }
        
        /* GSAP Text Reveal (for characters) */
        .landingpagecontainer-char-parent {
            overflow: hidden;
        }
        .landingpagecontainer-char-child {
            display: inline-block;
            transform: translateY(100%);
        }

        /* GSAP Image Reveal */
        .landingpagecontainer-image-wrapper {
            position: relative;
            overflow: hidden;
        }
        .landingpagecontainer-image-cover {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #F5F5F5;
            transform-origin: left;
        }
        .landingpagecontainer-image-wrapper img {
            opacity: 0;
            transform: scale(1.2);
            transition: opacity 0.8s ease-in-out, transform 0.8s ease-in-out;
        }
        .landingpagecontainer-image-wrapper.is-revealed img {
            opacity: 1;
            transform: scale(1);
        }
        .landingpagecontainer-image-wrapper.is-revealed .landingpagecontainer-image-cover {
            transform: scaleX(0);
            transform-origin: right;
            transition: transform 1.2s cubic-bezier(0.22, 1, 0.36, 1);
        }

        /* Video Hero Section */
        .landingpagecontainer-video-hero {
            height: 100vh;
            position: relative;
            overflow: hidden;
        }
        .landingpagecontainer-video-hero video {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 100%;
            height: 100%;
            object-fit: cover;
            transform: translate(-50%, -50%);
            z-index: 1;
        }
        .landingpagecontainer-video-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.3);
            z-index: 2;
        }
        .landingpagecontainer-hero-content {
            position: relative;
            z-index: 3;
        }

        /* Marquee Section */
        .landingpagecontainer-marquee {
            width: 100%;
            overflow: hidden;
            white-space: nowrap;
        }
        .landingpagecontainer-marquee-content {
            display: inline-block;
            animation: marquee-scroll 30s linear infinite;
        }
        .landingpagecontainer-marquee-item {
            display: inline-block;
            padding: 0 2rem;
        }
        @keyframes marquee-scroll {
            from { transform: translateX(0%); }
            to { transform: translateX(-50%); }
        }

        /* Sticky Stack Section */
        .landingpagecontainer-stack-section {
            position: relative;
        }
        .landingpagecontainer-stack-card {
            position: sticky;
            top: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
    </style>
</head>
<body class="antialiased">

    <main>
        <!-- VIDEO HERO SECTION -->
        <section class="landingpagecontainer-video-hero">
            <div class="landingpagecontainer-video-overlay"></div>
            <video playsinline autoplay muted loop poster="https://images.unsplash.com/photo-1520250497591-112f2f40a3f4?auto=format&fit=crop&w=1920&q=80">
                <source src="https://assets.mixkit.co/videos/preview/mixkit-decorated-table-in-a-restaurant-4433-large.mp4" type="video/mp4">
            </video>
            <div class="landingpagecontainer-hero-content h-full w-full flex flex-col justify-center items-center text-center p-6 text-white">
                <h1 class="landingpagecontainer-font-serif text-5xl md:text-8xl font-medium">
                    <div class="landingpagecontainer-line-parent">
                        <div class="landingpagecontainer-line-child">Floracion</div>
                    </div>
                    <div class="landingpagecontainer-line-parent">
                        <div class="landingpagecontainer-line-child">Hospitality</div>
                    </div>
                </h1>
                <div class="landingpagecontainer-line-parent mt-6">
                    <p class="landingpagecontainer-line-child text-lg md:text-xl opacity-90">Where Hospitality Blooms</p>
                </div>
            </div>
        </section>

        <!-- INTRO SECTION -->
        <section class="py-24 md:py-40 container mx-auto px-6 text-center">
            <h2 class="landingpagecontainer-font-serif text-3xl md:text-5xl font-medium leading-tight max-w-4xl mx-auto">
                <span class="landingpagecontainer-char-parent block">
                    <span class="landingpagecontainer-char-child">We</span> <span class="landingpagecontainer-char-child">curate</span> <span class="landingpagecontainer-char-child">premium</span> <span class="landingpagecontainer-char-child">properties—hotels,</span> 
                </span>
                 <span class="landingpagecontainer-char-parent block">
                    <span class="landingpagecontainer-char-child">resorts,</span> <span class="landingpagecontainer-char-child">and</span> <span class="landingpagecontainer-char-child">homestays—that</span> <span class="landingpagecontainer-char-child">blend</span> 
                </span>
                 <span class="landingpagecontainer-char-parent block">
                    <span class="landingpagecontainer-char-child">comfort</span> <span class="landingpagecontainer-char-child">with</span> <span class="landingpagecontainer-char-child">unforgettable</span> <span class="landingpagecontainer-char-child">elegance.</span>
                </span>
            </h2>
        </section>

        <!-- IMAGE GALLERY SECTION -->
        <section class="py-10 md:py-20 container mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 md:gap-12">
                <div class="md:col-span-1 md:pt-24">
                    <div class="landingpagecontainer-image-wrapper h-[70vh] rounded-lg">
                        <div class="landingpagecontainer-image-cover"></div>
                        <img src="https://images.unsplash.com/photo-1561501900-3701fa6a0864?auto=format&fit=crop&w=1920&q=80" alt="Luxury hotel pool" class="w-full h-full object-cover">
                    </div>
                </div>
                <div class="md:col-span-1">
                    <div class="landingpagecontainer-image-wrapper h-[70vh] rounded-lg">
                        <div class="landingpagecontainer-image-cover"></div>
                        <img src="https://images.unsplash.com/photo-1582719478250-c89cae4dc85b?auto=format&fit=crop&w=1920&q=80" alt="Elegant hotel suite" class="w-full h-full object-cover">
                    </div>
                </div>
            </div>
        </section>

        <!-- MARQUEE SECTION -->
        <section class="py-16 md:py-24 bg-gray-800 text-white">
            <div class="landingpagecontainer-marquee">
                <div class="landingpagecontainer-marquee-content landingpagecontainer-font-serif text-4xl md:text-6xl font-medium">
                    <span class="landingpagecontainer-marquee-item">Trusted Partnership</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <span class="landingpagecontainer-marquee-item">Guest-Centric</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <span class="landingpagecontainer-marquee-item">Maximized Returns</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <span class="landingpagecontainer-marquee-item">Elegance</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <!-- Duplicate for seamless loop -->
                    <span class="landingpagecontainer-marquee-item">Trusted Partnership</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <span class="landingpagecontainer-marquee-item">Guest-Centric</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <span class="landingpagecontainer-marquee-item">Maximized Returns</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                    <span class="landingpagecontainer-marquee-item">Elegance</span>
                    <span class="landingpagecontainer-marquee-item text-amber-300">&bull;</span>
                </div>
            </div>
        </section>

        <!-- STICKY STACK SERVICES SECTION -->
        <section class="landingpagecontainer-stack-section py-20 md:py-32">
            <div class="container mx-auto px-6 relative">
                <!-- Card 1 -->
                <div class="landingpagecontainer-stack-card" style="background-color: #F5F5F5; z-index: 1;">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div data-aos="fade-right">
                            <span class="text-amber-600">01</span>
                            <h3 class="landingpagecontainer-font-serif text-4xl md:text-6xl font-medium mt-2 mb-6">Hotel & Resort Leasing</h3>
                            <p class="text-lg text-gray-700 max-w-lg">Flexible, transparent leasing solutions for property owners. We handle the operations, you enjoy the returns.</p>
                        </div>
                        <div class="landingpagecontainer-image-wrapper h-[60vh] rounded-lg" data-aos="zoom-in">
                            <div class="landingpagecontainer-image-cover"></div>
                            <img src="https://images.unsplash.com/photo-1549294413-26f195200c16?auto=format&fit=crop&w=1920&q=80" alt="Hotel exterior" class="w-full h-full object-cover">
                        </div>
                    </div>
                </div>
                <div class="landingpagecontainer-stack-card" style="background-color: #ECEAE6; z-index: 2;">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div data-aos="fade-right">
                            <span class="text-amber-600">02</span>
                            <h3 class="landingpagecontainer-font-serif text-4xl md:text-6xl font-medium mt-2 mb-6">Curated Homestay Rentals</h3>
                            <p class="text-lg text-gray-700 max-w-lg">A handpicked collection of fully serviced homestays that offer the perfect blend of private comfort and local charm.</p>
                        </div>
                        <div class="landingpagecontainer-image-wrapper h-[60vh] rounded-lg" data-aos="zoom-in">
                             <div class="landingpagecontainer-image-cover"></div>
                            <img src="https://images.unsplash.com/photo-1611892440504-42a792e24d32?auto=format&fit=crop&w=1920&q=80" alt="Cozy homestay bedroom" class="w-full h-full object-cover">
                        </div>
                    </div>
                </div>
                <!-- Card 3 -->
                <div class="landingpagecontainer-stack-card" style="background-color: #E3E0DB; z-index: 3;">
                    <div class="grid md:grid-cols-2 gap-12 items-center">
                        <div data-aos="fade-right">
                            <span class="text-amber-600">03</span>
                            <h3 class="landingpagecontainer-font-serif text-4xl md:text-6xl font-medium mt-2 mb-6">Turnkey Management</h3>
                            <p class="text-lg text-gray-700 max-w-lg">Our expert team provides end-to-end property management, from marketing and guest services to maintenance.</p>
                        </div>
                        <div class="landingpagecontainer-image-wrapper h-[60vh] rounded-lg" data-aos="zoom-in">
                             <div class="landingpagecontainer-image-cover"></div>
                            <img src="https://images.unsplash.com/photo-1563911302283-d2bc129e7570?auto=format&fit=crop&w=1920&q=80" alt="Hotel staff" class="w-full h-full object-cover">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- PARTNER WITH US (CTA) SECTION -->
        <section class="py-24 md:py-40 bg-white">
            <div class="container mx-auto px-6 text-center">
                 <h2 class="landingpagecontainer-font-serif text-4xl md:text-7xl font-medium text-gray-800 mb-6" data-aos="fade-up">
                    Unlock Your Property's Potential.
                 </h2>
                 <p class="text-lg text-gray-600 max-w-2xl mx-auto mb-12" data-aos="fade-up" data-aos-delay="100">
                    Partner with us to transform your space into a thriving, profitable business. Let's create exceptional hospitality experiences together.
                 </p>
                 <div data-aos="fade-up" data-aos-delay="200">
                    <a href="owner/owner_login.php" class="inline-block bg-gray-800 text-white font-medium px-12 py-5 rounded-full hover:bg-black transition-all duration-300 text-lg transform hover:scale-105">
                        Become a Partner
                    </a>
                 </div>
            </div>
        </section>

    </main>

    <!-- GSAP (GreenSock Animation Platform) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    <script src="https://unpkg.com/split-type"></script>

    <!-- AOS (Animate on Scroll) -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <!-- Custom Animation Script -->
    <script>
        // Initialize AOS
        AOS.init({
            once: true,
            duration: 900,
            easing: 'ease-in-out',
        });

        // Register GSAP plugins
        gsap.registerPlugin(ScrollTrigger);

        // --- GSAP ANIMATIONS ---

        // 1. Hero Text Reveal (Lines)
        gsap.to(".landingpagecontainer-line-child", {
            y: 0,
            stagger: 0.1,
            delay: 0.3,
            duration: 1.5,
            ease: "power4.out"
        });

        // 2. Intro Text Reveal (Characters)
        const introText = new SplitType('.landingpagecontainer-char-parent', { types: 'words, chars' });
        gsap.from(introText.chars, {
            scrollTrigger: {
                trigger: '.landingpagecontainer-char-parent',
                start: 'top 80%',
                end: 'bottom 60%',
                scrub: true,
            },
            opacity: 0.2,
            stagger: 0.1,
        });

        // 3. Image Reveal Animation
        const imageWrappers = document.querySelectorAll('.landingpagecontainer-image-wrapper');
        imageWrappers.forEach(wrapper => {
            gsap.to(wrapper, {
                scrollTrigger: {
                    trigger: wrapper,
                    start: "top 85%",
                    toggleClass: "is-revealed",
                    once: true,
                }
            });
        });

        // 4. Sticky Stack Section
        const stackCards = gsap.utils.toArray(".landingpagecontainer-stack-card");
        stackCards.forEach((card, index) => {
            // We don't animate the last card, it just sits at the bottom
            if (index === stackCards.length - 1) return;

            gsap.to(card, {
                scale: 0.9,
                scrollTrigger: {
                    trigger: card,
                    start: "bottom bottom", // When the bottom of the card hits the bottom of the viewport
                    end: "bottom top", // When the bottom of the card hits the top of the viewport
                    scrub: 0.5,
                }
            });
        });

    </script>

</body>
</html>
