<?php
// --- Icon SVGs ---
// Storing SVGs in variables to keep the HTML clean. This replaces the react-icons library.
$icons = [
    'mapPin' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-xl md:text-2xl text-green-600"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>',
    'thumbsUp' => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path></svg>',
    'fileText' => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>',
    'award' => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="8" r="7"></circle><polyline points="8.21 13.89 7 23 12 20 17 23 15.79 13.88"></polyline></svg>',
    'trendingUp' => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline><polyline points="17 6 23 6 23 12"></polyline></svg>',
    'shield' => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>',
    'chevronDown' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="chevron-icon transform transition-transform duration-300"><polyline points="6 9 12 15 18 9"></polyline></svg>',
    'arrowRight' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline-block transition-transform duration-300 group-hover:translate-x-1"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>',
];

// --- Data for the "Why Choose Us" section ---
$whyChooseUsData = [
    ['icon' => $icons['thumbsUp'], 'title' => "Trusted", 'desc' => "By travelers and property owners alike for our commitment and results."],
    ['icon' => $icons['fileText'], 'title' => "Transparent", 'desc' => "Clear terms and flexible agreements tailored to your specific needs."],
    ['icon' => $icons['award'], 'title' => "Proven", 'desc' => "A strong track record in hospitality management and guest satisfaction."],
    ['icon' => $icons['trendingUp'], 'title' => "ROI-Focused", 'desc' => "Our goal is to maximize your returns while ensuring guest happiness."],
    ['icon' => $icons['shield'], 'title' => "End-to-End", 'desc' => "Comprehensive management services that cover every single detail."],
];
?>

<div id="more-info-page" class="bg-white text-gray-800 font-sans overflow-x-hidden">
    
    <!-- 1. Where We Operate Section -->
    <section class="operate-section relative w-full min-h-screen bg-gray-100 flex items-center justify-center overflow-hidden py-20 lg:py-0">
        <div class="container mx-auto px-6 flex flex-col lg:flex-row items-center gap-12 lg:gap-24">
            <!-- Text Content -->
            <div class="w-full lg:w-1/3 text-center lg:text-left">
                <div class="animated-title-wrapper overflow-hidden py-1">
                    <h2 class="animated-title text-4xl md:text-5xl font-medium leading-tight">Where We Operate</h2>
                </div>
                <p class="mt-6 text-gray-600 leading-relaxed">
                    Floracion Hospitality operates across prime tourist destinations. Whether it's a serene mountain homestay or a bustling city hotel, we bring consistent quality and care to every location.
                </p>
            </div>

            <!-- Stylized Map -->
            <div class="w-full lg:w-2/3 relative max-w-2xl lg:max-w-none mx-auto">
                <svg class="w-full h-auto drop-shadow-2xl" viewBox="0 0 554 629" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M128.5 221.5L118 211L107.5 221.5L103.5 229L100 241L103.5 251.5L100 259L107.5 271L114 279L118 284L107.5 288L100 299.5L107.5 308L114 313L118 320.5L128.5 329.5L135 334L143 337.5L150 342.5L153.5 352L150 361L153.5 370L150 379L143 388L135 401.5L128.5 413L125 422.5L128.5 435.5L135 448L143 456L150 464.5L153.5 478L150 490L153.5 500.5L159 511.5L167 520L174 527.5L183.5 533L191.5 540L200 546L207.5 552.5L214.5 557.5L221.5 561.5L230 564.5L239.5 566L248 564.5L257 561.5L263.5 557.5L271.5 552.5L278.5 546L285 540L291.5 533L298 527.5L304.5 520L311 511.5L317 500.5L323.5 490L329 478L335.5 464.5L342.5 456L348.5 448L355 435.5L361.5 422.5L367 413L373.5 401.5L380 388L386.5 379L392 370L398.5 361L404.5 352L411 342.5L417.5 337.5L424 334L430.5 329.5L436.5 320.5L442.5 313L448.5 308L455 299.5L461.5 288L467.5 284L474 279L480.5 271L486.5 259L492.5 251.5L498.5 241L504.5 229L511 221.5L517.5 211L523.5 200.5L530 190L536.5 179.5L542.5 168.5L548.5 157.5L554 146.5L554 135.5L548.5 124.5L542.5 113.5L536.5 102.5L530 91.5L523.5 80.5L517.5 69.5L511 58.5L504.5 47.5L498.5 36.5L492.5 25.5L486.5 14.5L480.5 3.5L474 0L467.5 3.5L461.5 14.5L455 25.5L448.5 36.5L442.5 47.5L436.5 58.5L430.5 69.5L424 80.5L417.5 91.5L411 102.5L404.5 113.5L398.5 124.5L392 135.5L386.5 146.5L380 157.5L373.5 168.5L367 179.5L361.5 190L355 200.5L348.5 211L342.5 221.5L335.5 229L329 241L323.5 251.5L317 259L311 271L304.5 279L298 284L291.5 288L285 299.5L278.5 308L271.5 313L263.5 320.5L257 329.5L248 334L239.5 337.5L230 342.5L221.5 352L214.5 361L207.5 370L200 379L191.5 388L183.5 401.5L174 413L167 422.5L159 435.5L153.5 448L150 456L143 464.5L135 478L128.5 490L125 500.5L118 511.5L114 520L107.5 527.5L100 533L91.5 540L83.5 546L76.5 552.5L69.5 557.5L62.5 561.5L54 564.5L44.5 566L36 564.5L27 561.5L20.5 557.5L13.5 552.5L6.5 546L0 540L6.5 533L13.5 527.5L20.5 520L27 511.5L33.5 500.5L40 490L46.5 478L53.5 464.5L60.5 456L66.5 448L73 435.5L79.5 422.5L85 413L91.5 401.5L98 388L104.5 379L111 370L117.5 361L124 352L130.5 342.5L137 337.5L143.5 334L150 329.5L156 320.5L162 313L168 308L174.5 299.5L181 288L187 284L193.5 279L200 271L206 259L212 251.5L218 241L224 229L230.5 221.5L237 211L243 200.5L249.5 190L256 179.5L262 168.5L268 157.5L274 146.5L280 135.5L286.5 124.5L292.5 113.5L298.5 102.5L304.5 91.5L311 80.5L317 69.5L323.5 58.5L329 47.5L335.5 36.5L342.5 25.5L348.5 14.5L355 3.5L361.5 0L367 3.5L373.5 14.5L380 25.5L386.5 36.5L392 47.5L398.5 58.5L404.5 69.5L411 80.5L417.5 91.5L424 102.5L430.5 113.5L436.5 124.5L442.5 135.5L448.5 146.5L455 157.5L461.5 168.5L467.5 179.5L474 190L480.5 200.5L486.5 211L492.5 221.5L498.5 229L504.5 241L511 251.5L517.5 259L523.5 271L530 279L536.5 284L542.5 288L548.5 299.5L554 308L548.5 313L542.5 320.5L536.5 329.5L530 334L523.5 337.5L517.5 342.5L511 352L504.5 361L498.5 370L492.5 379L486.5 388L480.5 401.5L474 413L467.5 422.5L461.5 435.5L455 448L448.5 456L442.5 464.5L436.5 478L430.5 490L424 500.5L417.5 511.5L411 520L404.5 527.5L398.5 533L392 540L386.5 546L380 552.5L373.5 557.5L367 561.5L361.5 564.5L355 566L348.5 564.5L342.5 561.5L335.5 557.5L329 552.5L323.5 546L317 540L311 533L304.5 527.5L298 520L291.5 511.5L285 500.5L278.5 490L271.5 478L263.5 464.5L257 456L248 448L239.5 435.5L230 422.5L221.5 413L214.5 401.5L207.5 388L200 379L191.5 370L183.5 361L174.5 352L168 342.5L162 337.5L156 334L150 329.5L143.5 320.5L137 313L130.5 308L124 299.5L117.5 288L111 284L104.5 279L98 271L91.5 259L85 251.5L79.5 241L73 229L66.5 221.5L60.5 211L53.5 200.5L46.5 190L40 179.5L33.5 168.5L27 157.5L20.5 146.5L13.5 135.5L6.5 124.5L0 113.5L6.5 102.5L13.5 91.5L20.5 80.5L27 69.5L33.5 58.5L40 47.5L46.5 36.5L53.5 25.5L60.5 14.5L66.5 3.5L73 0L79.5 3.5L85 14.5L91.5 25.5L98 36.5L104.5 47.5L111 58.5L117.5 69.5L124 80.5L130.5 91.5L137 102.5L143.5 113.5L150 124.5L156 135.5L162 146.5L168 157.5L174.5 168.5L181 179.5L187 190L193.5 200.5L200 211L206 221.5L212 229L218 241L224 251.5L230.5 259L237 271L243 279L249.5 284L256 288L262 299.5L268 308L274 313L280 320.5L286.5 329.5L292.5 334L298.5 337.5L304.5 342.5L311 352L317 361L323.5 370L329 379L335.5 388L342.5 401.5L348.5 413L355 422.5L361.5 435.5L367 448L373.5 456L380 464.5L386.5 478L392 490L398.5 500.5L404.5 511.5L411 520L417.5 527.5L424 533L430.5 540L436.5 546L442.5 552.5L448.5 557.5L455 561.5L461.5 564.5L467.5 566L474 564.5L480.5 561.5L486.5 557.5L492.5 552.5L498.5 546L504.5 540L511 533L517.5 527.5L523.5 520L530 511.5L536.5 500.5L542.5 490L548.5 478L554 464.5L548.5 456L542.5 448L536.5 435.5L530 422.5L523.5 413L517.5 401.5L511 388L504.5 379L498.5 370L492.5 361L486.5 352L480.5 342.5L474 337.5L467.5 334L461.5 329.5L455 320.5L448.5 313L442.5 308L436.5 299.5L430.5 288L424 284L417.5 279L411 271L404.5 259L398.5 251.5L392 241L386.5 229L380 221.5L373.5 211L367 200.5L361.5 190L355 179.5L348.5 168.5L342.5 157.5L335.5 146.5L329 135.5L323.5 124.5L317 113.5L311 102.5L304.5 91.5L298.5 80.5L292.5 69.5L286.5 58.5L280 47.5L274 36.5L268 25.5L262 14.5L256 3.5L249.5 0L243 3.5L237 14.5L230.5 25.5L224 36.5L218 47.5L212 58.5L206 69.5L200 80.5L193.5 91.5L187 102.5L181 113.5L174.5 124.5L168 135.5L162 146.5L156 157.5L150 168.5L143.5 179.5L137 190L130.5 200.5L124 211L118 221.5Z" fill="#E5E7EB"/>
                </svg>
                <!-- Location Dots -->
                <div class="location-dot absolute top-[25%] left-[30%] group">
                    <?php echo $icons['mapPin']; ?>
                    <span class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 w-max bg-gray-900 text-white text-xs rounded py-1 px-2 opacity-0 group-hover:opacity-100 transition-opacity">Hill Stations</span>
                </div>
                <div class="location-dot absolute top-[70%] left-[20%] group">
                    <?php echo $icons['mapPin']; ?>
                    <span class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 w-max bg-gray-900 text-white text-xs rounded py-1 px-2 opacity-0 group-hover:opacity-100 transition-opacity">Coastal Regions</span>
                </div>
                <div class="location-dot absolute top-[50%] left-[55%] group">
                    <?php echo $icons['mapPin']; ?>
                    <span class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 w-max bg-gray-900 text-white text-xs rounded py-1 px-2 opacity-0 group-hover:opacity-100 transition-opacity">Urban Escapes</span>
                </div>
            </div>
        </div>
    </section>

    <!-- 2. Why Choose Us Section -->
    <section class="why-choose-us-section bg-white w-full flex flex-col justify-center py-20">
        <div class="container mx-auto px-6 text-center mb-12 md:mb-16">
            <div class="animated-title-wrapper overflow-hidden py-1">
                <h2 class="animated-title text-4xl md:text-5xl font-medium">Why Choose Floracion?</h2>
            </div>
        </div>

        <!-- Desktop View (Expanding Accordion) -->
        <div class="why-choose-us-desktop hidden lg:flex w-full">
            <?php foreach ($whyChooseUsData as $i => $reason): ?>
                <div class="reason-item-desktop relative flex-1 p-8 lg:p-12 border-r border-gray-200 last:border-r-0 flex flex-col justify-center items-start text-left cursor-pointer overflow-hidden">
                    <div class="flex items-center gap-4 text-gray-800">
                        <?php echo $reason['icon']; ?>
                        <h3 class="text-xl font-semibold whitespace-nowrap"><?php echo htmlspecialchars($reason['title']); ?></h3>
                    </div>
                    <div class="reason-content w-0 mt-4">
                        <p class="text-gray-600 whitespace-nowrap"><?php echo htmlspecialchars($reason['desc']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Mobile View (Clickable Accordion) -->
        <div class="w-full lg:hidden flex flex-col container mx-auto px-6">
            <?php foreach ($whyChooseUsData as $i => $reason): ?>
                <div class="reason-item-mobile border-b border-gray-200 last:border-b-0">
                    <button class="w-full flex justify-between items-center text-left p-6">
                        <div class="flex items-center gap-4 text-gray-800">
                            <?php echo $reason['icon']; ?>
                            <h3 class="text-lg font-semibold"><?php echo htmlspecialchars($reason['title']); ?></h3>
                        </div>
                        <?php echo $icons['chevronDown']; ?>
                    </button>
                    <div class="accordion-content overflow-hidden transition-all duration-500 ease-in-out max-h-0">
                        <p class="text-gray-600 p-6 pt-0"><?php echo htmlspecialchars($reason['desc']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>

    <!-- 3. Partner With Us (CTA) -->
    <section class="partner-section relative w-full h-[70vh] md:h-[80vh] bg-gray-900 text-white flex items-center justify-center text-center overflow-hidden">
        <div class="partner-bg absolute inset-0 bg-cover bg-center bg-fixed" style="background-image: url(https://images.unsplash.com/photo-1582719508461-905c673771fd?q=80&w=2825&auto=format&fit=crop)"></div>
        <div class="absolute inset-0 bg-black/70"></div>
        <div class="relative z-10 p-6">
            <div class="animated-title-wrapper overflow-hidden py-1">
                <h2 class="animated-title text-4xl md:text-6xl font-medium tracking-tight">Become a Partner</h2>
            </div>
            <p class="max-w-2xl mx-auto mt-6 text-base md:text-lg text-white/80">
                Are you a property owner looking to unlock your property’s full potential? Let’s work together to turn your space into a thriving business.
            </p>
            <button class="mt-10 md:mt-12 bg-white text-gray-900 font-bold px-8 py-3 md:px-10 md:py-4 rounded-full text-base md:text-lg group hover:bg-gray-200 transition-all">
                Get In Touch <?php echo $icons['arrowRight']; ?>
            </button>
        </div>
    </section>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    // --- GSAP Animations for MoreInfoPage ---
    if (typeof gsap === 'undefined' || typeof ScrollTrigger === 'undefined') {
        console.error('GSAP or ScrollTrigger is not loaded.');
        return;
    }

    const page = document.getElementById('more-info-page');
    if (!page) return;

    // --- Animated Titles ---
    const titles = gsap.utils.toArray('.animated-title');
    titles.forEach(title => {
        gsap.from(title, {
            yPercent: 100,
            opacity: 0,
            duration: 1,
            ease: 'power3.out',
            scrollTrigger: {
                trigger: title.parentElement, // Use the wrapper as the trigger
                start: 'top 90%',
            }
        });
    });

    // --- "Where We Operate" Map Animation ---
    const locations = gsap.utils.toArray('.location-dot');
    gsap.timeline({
        scrollTrigger: {
            trigger: '.operate-section',
            start: 'top 50%',
            toggleActions: 'play none none reverse',
        }
    }).from(locations, {
        scale: 0,
        opacity: 0,
        stagger: 0.2,
        duration: 0.8,
        ease: 'back.out(1.7)'
    });

    // --- RESPONSIVE GSAP: Desktop & Mobile Accordions ---
    ScrollTrigger.matchMedia({
        // Desktop view: Hover-based expanding accordion
        "(min-width: 1024px)": function() {
            const reasons = gsap.utils.toArray('.reason-item-desktop');
            reasons.forEach(reason => {
                const content = reason.querySelector('.reason-content');
                gsap.set(content, { width: 0, opacity: 0, paddingLeft: 0 });
            });

            const container = document.querySelector('.why-choose-us-desktop');

            container.addEventListener('mouseenter', (e) => {
                const hoveredItem = e.target.closest('.reason-item-desktop');
                if (!hoveredItem) return;

                reasons.forEach(reason => {
                    const content = reason.querySelector('.reason-content');
                    if (reason === hoveredItem) {
                        gsap.to(reason, { flex: 2, duration: 0.7, ease: 'power3.inOut' });
                        gsap.to(content, { width: 'auto', opacity: 1, paddingLeft: '1rem', duration: 0.7, ease: 'power3.inOut' });
                    } else {
                        gsap.to(reason, { flex: 0.5, duration: 0.7, ease: 'power3.inOut' });
                        gsap.to(content, { width: 0, opacity: 0, paddingLeft: 0, duration: 0.7, ease: 'power3.inOut' });
                    }
                });
            });

            container.addEventListener('mouseleave', () => {
                reasons.forEach(reason => {
                    gsap.to(reason, { flex: 1, duration: 0.7, ease: 'power3.inOut' });
                    gsap.to(reason.querySelector('.reason-content'), { width: 0, opacity: 0, paddingLeft: 0, duration: 0.7, ease: 'power3.inOut' });
                });
            });
        },
        // Mobile view: Click-based accordion
        "(max-width: 1023px)": function() {
            const mobileReasons = gsap.utils.toArray('.reason-item-mobile');
            let openAccordion = null;

            mobileReasons.forEach((reason, index) => {
                const button = reason.querySelector('button');
                const content = reason.querySelector('.accordion-content');
                const icon = reason.querySelector('.chevron-icon');

                button.addEventListener('click', () => {
                    if (openAccordion === reason) {
                        // Close the currently open one
                        gsap.to(content, { maxHeight: 0, duration: 0.5, ease: 'power2.inOut' });
                        gsap.to(icon, { rotation: 0, duration: 0.3 });
                        openAccordion = null;
                    } else {
                        // Close the previously open one (if any)
                        if (openAccordion) {
                            const prevContent = openAccordion.querySelector('.accordion-content');
                            const prevIcon = openAccordion.querySelector('.chevron-icon');
                            gsap.to(prevContent, { maxHeight: 0, duration: 0.5, ease: 'power2.inOut' });
                            gsap.to(prevIcon, { rotation: 0, duration: 0.3 });
                        }
                        // Open the new one
                        gsap.to(content, { maxHeight: content.scrollHeight, duration: 0.5, ease: 'power2.inOut' });
                        gsap.to(icon, { rotation: 180, duration: 0.3 });
                        openAccordion = reason;
                    }
                });
            });
        }
    });

    // --- Partner With Us Parallax Background ---
    gsap.to('.partner-bg', {
        backgroundPosition: '50% 100%',
        ease: 'none',
        scrollTrigger: {
            trigger: '.partner-section',
            start: 'top bottom',
            end: 'bottom top',
            scrub: true,
        }
    });
});
</script>
