<?php
// FILE: available_properties.php (Updated to Show Rates)

// 1. INCLUDE DATABASE CONNECTION
require_once 'config/db.php';

// 2. FETCH **ONLY ACTIVE** PROPERTIES FROM THE DATABASE - **Added 'rate' to the query**
$sql = "SELECT id, property_type, rate, header, description, location, rules, image1, image2, image3, image4 FROM properties WHERE status = 'active' ORDER BY upload_date DESC";
$result = $link->query($sql);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Available Properties - Hospitality</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <style>
        :root {
            --primary-color: #1a2e39; /* Deep, dark blue */
            --secondary-color: #c0a080; /* Soft gold/bronze */
            --background-color: #fdfdfd;
            --card-background: #ffffff;
            --text-color: #1a2e39;
            --light-text-color: #6c757d;
            --shadow: 0 10px 30px rgba(0, 0, 0, 0.07);
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--background-color);
            color: var(--text-color);
            overflow-x: hidden;
        }
        .page-container {
            width: 100%;
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 2rem;
        }
        .hero-section {
            height: 70vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            margin-bottom: 5rem;
        }
        .hero-title {
            font-family: 'Playfair Display', serif;
            font-size: clamp(2.5rem, 6vw, 5rem);
            font-weight: 700;
            line-height: 1.1;
            margin-bottom: 1rem;
            clip-path: polygon(0 0, 100% 0, 100% 100%, 0% 100%);
        }
        .hero-subtitle {
            font-size: clamp(1rem, 2vw, 1.25rem);
            color: var(--light-text-color);
            max-width: 600px;
            margin-bottom: 2rem;
            opacity: 0;
        }
        .decorative-line {
            width: 100px;
            height: 2px;
            background-color: var(--secondary-color);
            transform: scaleX(0);
            transform-origin: center;
        }
        .property-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 3rem;
            padding-bottom: 5rem;
        }
        .property-card {
            background: var(--card-background);
            border-radius: 8px;
            box-shadow: var(--shadow);
            display: flex;
            flex-direction: column;
            overflow: hidden;
            opacity: 0;
            transform: translateY(50px);
            text-decoration: none;
            color: var(--text-color);
        }
        .card-image-wrapper {
            height: 250px;
            overflow: hidden;
            position: relative;
        }
        .card-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.6s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }
        .property-card:hover .card-image {
            transform: scale(1.05);
        }
        .card-content {
            padding: 1.5rem;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }
        .card-header {
            font-family: 'Playfair Display', serif;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        .card-property-type {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--secondary-color);
            margin-bottom: 0.5rem; /* Adjusted margin */
            display: flex;
            align-items: center;
            gap: 8px;
        }
        /* Style for the new Rate display */
        .card-rate {
            font-size: 1.6rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        .card-rate i {
            font-size: 1.2rem;
            margin-right: 4px;
        }
        .card-rate span {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--light-text-color);
        }
        .card-description {
            font-size: 0.95rem;
            line-height: 1.6;
            color: var(--light-text-color);
            margin-bottom: 1.5rem;
            flex-grow: 1;
        }
        .card-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid #f0f0f0;
            padding-top: 1rem;
        }
        .card-rules {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.9rem;
            color: var(--light-text-color);
        }
        .view-details-btn {
            padding: 10px 20px;
            background-color: var(--primary-color);
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 500;
            transition: background-color 0.3s, transform 0.3s;
        }
        .property-card:hover .view-details-btn {
            background-color: #000;
            transform: scale(1.05);
        }
        .no-properties {
            grid-column: 1 / -1;
            text-align: center;
            padding: 5rem 2rem;
            background-color: #fff;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <div class="page-container">
        <section class="hero-section">
            <h1 class="hero-title">
                <span class="line">Find Your</span><br>
                <span class="line">Perfect Stay</span>
            </h1>
            <p class="hero-subtitle">
                Explore our curated collection of exquisite properties, each offering a unique experience tailored for comfort and luxury.
            </p>
            <div class="decorative-line"></div>
        </section>

        <main class="property-grid" id="property-grid">
            <?php if ($result && $result->num_rows > 0): ?>
                <?php while($row = $result->fetch_assoc()): ?>
                    <?php
                        $images = [];
                        if (!empty($row['image1'])) $images[] = $row['image1'];
                        if (!empty($row['image2'])) $images[] = $row['image2'];
                        if (!empty($row['image3'])) $images[] = $row['image3'];
                        if (!empty($row['image4'])) $images[] = $row['image4'];
                    ?>
                    <a href="property_details.php?id=<?php echo $row['id']; ?>" class="property-card" data-aos="fade-up">
                        <div class="card-image-wrapper">
                            <div class="swiper card-slider">
                                <div class="swiper-wrapper">
                                    <?php if (!empty($images)): ?>
                                        <?php foreach ($images as $img_path): ?>
                                            <div class="swiper-slide">
                                                <img src="owner/<?php echo htmlspecialchars($img_path); ?>" class="card-image" alt="Property Image">
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="swiper-slide" style="display:flex; justify-content:center; align-items:center; background-color:#e9ecef;">
                                            <i class="fas fa-hotel fa-3x" style="color: var(--light-text-color);"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-content">
                            <div>
                                <h3 class="card-header"><?php echo htmlspecialchars($row['header']); ?></h3>
                                <p class="card-property-type">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <span><?php echo htmlspecialchars($row['location']); ?> • <?php echo htmlspecialchars($row['property_type']); ?></span>
                                </p>
                                <div class="card-rate">
                                    <i class="fas fa-indian-rupee-sign"></i><?php echo number_format($row['rate'], 2); ?>
                                    <span>/ night</span>
                                </div>
                                <p class="card-description">
                                    <?php echo htmlspecialchars(substr($row['description'], 0, 100)) . (strlen($row['description']) > 100 ? '...' : ''); ?>
                                </p>
                            </div>
                            <div class="card-footer">
                                <div class="card-rules" title="<?php echo htmlspecialchars($row['rules']); ?>">
                                    <i class="fas fa-info-circle"></i>
                                    <span>View Rules</span>
                                </div>
                                <span class="view-details-btn">View Details</span>
                            </div>
                        </div>
                    </a>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="no-properties">
                    <i class="fas fa-house-signal"></i>
                    <h2>No Properties Available</h2>
                    <p>We're sorry, but there are currently no available properties. Please check back later.</p>
                </div>
            <?php endif; ?>
        </main>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/SplitText.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <script>
    document.addEventListener('DOMContentLoaded', () => {
        gsap.registerPlugin(ScrollTrigger, SplitText);
        AOS.init({ once: true, duration: 800 });

        const heroTitle = new SplitText(".hero-title", { type: "lines" });
        const heroTl = gsap.timeline({ defaults: { ease: 'power4.out' } });

        heroTl
            .from(heroTitle.lines, { y: 100, opacity: 0, stagger: 0.1, duration: 1 })
            .to(".decorative-line", { scaleX: 1, duration: 0.8 }, "-=0.5")
            .to(".hero-subtitle", { opacity: 1, y: 0, duration: 0.8 }, "-=0.5");
            
        document.querySelectorAll('.card-slider').forEach(slider => {
            const slides = slider.querySelectorAll('.swiper-slide');
            if (slides.length > 1) {
                new Swiper(slider, {
                    loop: true, effect: 'fade',
                    fadeEffect: { crossFade: true },
                    autoplay: { delay: 3000 + Math.random() * 2000, disableOnInteraction: false }
                });
            }
        });
    });
    </script>
</body>
</html>
<?php
$link->close();
?>