<!-- 
    =======================================================================
    ====================== CTA (Call to Action) Section ===================
    =======================================================================
    
    INSTRUCTIONS:
    1. Save this file as 'cta.php' in your project (e.g., in a 'sections' folder).
    2. In your main PHP template (e.g., index.php), include this file where you want it to appear:
       <?php include 'sections/cta.php'; ?>
    3. Ensure you have the GSAP and Tailwind CSS CDN links in the <head> of your main template.
-->

<section id="cta-section" class="relative bg-white font-sans w-full overflow-x-hidden">
    
    <!-- Top Marquee Section -->
    <div class="border-y border-gray-200 py-4 md:py-6">
        <div class="relative flex overflow-hidden whitespace-nowrap">
            <!-- 
                The marquee content is duplicated to create a seamless loop.
                The GSAP animation will move this entire div to the left.
            -->
            <div id="marquee-inner" class="flex">
                <?php for ($i = 0; $i < 10; $i++): ?>
                    <div class="flex items-center mx-4 md:mx-8">
                        <span class="text-lg md:text-2xl font-medium text-gray-800">Let's Work Together</span>
                        <span class="mx-4 text-gray-300">•</span>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
    </div>

    <!-- Main CTA Content -->
    <div class="container mx-auto px-4 sm:px-6 py-20 md:py-32 text-center">
        <h2 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-medium text-gray-900 leading-tight">
            <!-- Each line is wrapped for the GSAP entrance animation -->
            <div class="overflow-hidden py-1"><div class="g-cta-line">Own a property?</div></div>
            <div class="overflow-hidden py-1"><div class="g-cta-line">Let's grow together.</div></div>
        </h2>
        <p class="g-cta-line max-w-2xl mx-auto mt-6 text-base md:text-lg text-gray-600">
            Unlock your property’s full potential. We turn your space into a thriving business—while you enjoy peace of mind and profit.
        </p>
        <div class="g-cta-button mt-10 md:mt-12">
            <button class="bg-gray-900 text-white font-medium px-8 py-3 md:px-10 md:py-4 rounded-full flex items-center gap-2 mx-auto group hover:bg-gray-700 transition-all duration-300 ease-in-out hover:scale-105">
               <a href="../owner/owner_login.php">Get In Touch Today</a> 
                <!-- SVG Icon replacement for FiArrowRight -->
                <svg class="transition-transform duration-300 group-hover:translate-x-1" stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M5 12h14M12 5l7 7-7 7"></path></svg>
            </button>
        </div>
    </div>
</section>

<!-- 
    =======================================================================
    ====================== GSAP Animation Script ==========================
    =======================================================================
-->
<script>
document.addEventListener('DOMContentLoaded', () => {

    // Ensure GSAP and ScrollTrigger are available
    if (typeof gsap !== 'undefined') {
        
        // Register the ScrollTrigger plugin
        gsap.registerPlugin(ScrollTrigger);

        const ctaSection = document.querySelector('#cta-section');
        const marqueeInner = document.querySelector('#marquee-inner');

        // --- Marquee/Ticker Animation ---
        if (marqueeInner) {
            // Calculate half the width of the marquee content for a seamless loop
            const marqueeWidth = marqueeInner.scrollWidth / 2;
            gsap.to(marqueeInner, {
                x: -marqueeWidth,
                duration: 20, // Adjust duration to change speed
                ease: 'none',
                repeat: -1, // Loop indefinitely
            });
        }

        // --- Entrance Animation on Scroll ---
        if(ctaSection) {
            const tl = gsap.timeline({
                scrollTrigger: {
                    trigger: ctaSection,
                    start: 'top 60%', // Animation starts when the top of the section is 60% from the top of the viewport
                    toggleActions: 'play none none reverse', // Play on enter, reverse on leave
                }
            });

            // Animate the text lines sliding up
            tl.from('.g-cta-line', {
                yPercent: 100,
                duration: 1,
                ease: 'power3.out',
                stagger: 0.1, // Stagger the animation for each line
            })
            // Animate the button fading in and moving up
            .from('.g-cta-button', {
                opacity: 0,
                y: 30,
                duration: 0.8,
                ease: 'power3.out',
            }, "-=0.5"); // Start this animation 0.5s before the previous one finishes
        }
    } else {
        console.error("GSAP is not loaded. Please ensure the GSAP CDN script is included in your HTML.");
    }
});
</script>