<?php
// Ensure this path is correct for your project structure
require_once "config/db.php"; 

// --- Fetch the latest hero image from the database ---

// Prepare and execute the query to get the most recently uploaded image
$query = "SELECT image_path FROM hero_poster ORDER BY uploaded_at DESC LIMIT 1";
$result = mysqli_query($link, $query);

// Check if a result was found and update the heroImage variable
if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    // Prepend the path to your uploads folder if it's not stored in the DB
    $heroImage = 'owner/' . $row['image_path']; 
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Floracion Premium Stays | Home</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-black">

    <section id="herohome" class="relative h-screen w-full overflow-hidden text-white font-sans">
        
        <!-- DYNAMIC BACKGROUND IMAGE -->
        <div
            class="herohome-bg absolute inset-0 bg-cover bg-center"
            style="background-image: url('<?php echo htmlspecialchars($heroImage); ?>');" 
        ></div>
        
        <div class="herohome-overlay absolute inset-0 bg-black/40"></div>

        <div class="relative z-10 h-full w-full p-4 sm:p-8 md:p-12 flex flex-col justify-between">

            <div class="herohome-g-stats absolute bottom-24 left-1/2 -translate-x-1/2 flex w-full justify-center gap-4 md:w-auto md:left-auto md:bottom-auto md:top-24 md:right-12 md:translate-x-0 md:gap-10 text-sm">
                <div class="text-center">
                    <p class="font-bold text-lg md:text-xl">15+</p>
                    <p class="text-gray-300 text-[10px] md:text-xs uppercase tracking-widest">Locations</p>
                </div>
                <div class="text-center">
                    <p class="font-bold text-lg md:text-xl">50+</p>
                    <p class="text-gray-300 text-[10px] md:text-xs uppercase tracking-widest">Properties</p>
                </div>
                <div class="text-center">
                    <p class="font-bold text-lg md:text-xl">1k+</p>
                    <p class="text-gray-300 text-[10px] md:text-xs uppercase tracking-widest">Happy Guests</p>
                </div>
            </div>

            <div class="absolute top-1/2 left-0 -translate-y-1/2 w-full px-4 sm:px-8 md:px-12">
                <div class="flex flex-col md:flex-row md:justify-between md:items-center">
                    <div class="text-left">
                        <h1 class="herohome-g-hero-line font-extrabold text-5xl sm:text-6xl md:text-8xl lg:text-9xl tracking-tighter">Floracion</h1>
                        <h1 class="herohome-g-hero-line font-light text-5xl sm:text-6xl md:text-8xl lg:text-9xl tracking-tighter">Premium</h1>
                        <p class="text-sm sm:text-base ml-1">Where Hospitality Blooms</p>
                    </div>
                    <div class="text-left md:text-right">
                         <h1 class="herohome-g-hero-line font-light text-5xl sm:text-6xl md:text-8xl lg:text-9xl tracking-tighter">Stays</h1>
                    </div>
                </div>
            </div>

            <div class="herohome-g-book-btn absolute bottom-40 left-1/2 -translate-x-1/2 w-max md:w-auto md:left-auto md:bottom-auto md:top-1/2 md:right-6 md:translate-x-0 md:-translate-y-1/2 md:rotate-90 md:origin-top-right">
                <a href="#" class="flex items-center gap-3 text-sm font-medium tracking-widest uppercase hover:text-gray-300 transition-colors">
                    Book Your Stay 
                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M5 12h14M12 5l7 7-7 7"></path></svg>
                </a>
            </div>

            <div class="herohome-g-bottom-right absolute bottom-4 right-4 sm:bottom-8 sm:right-8 md:bottom-12 md:right-12 flex items-center gap-4 text-sm">
                <div class="text-right">
                    <p class="font-semibold">Prime Locations</p>
                    <p class="text-gray-300">India</p>
                </div>
                <div class="h-10 w-10 rounded-full border border-white/50 flex items-center justify-center">
                    <span class="text-xs">MAP</span>
                </div>
            </div>
        </div>
    </section>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>

    <script>
        // Wait for the DOM to be fully loaded before running animations
        document.addEventListener('DOMContentLoaded', () => {
            
            // This scope limits GSAP's selectors to the #herohome section
            const heroScope = document.querySelector('#herohome');

            const tl = gsap.timeline({
                defaults: { ease: 'power3.out', duration: 1.2 },
                delay: 1.8
            });

            // GSAP animations remain unchanged
            tl.fromTo('.herohome-overlay', { opacity: 0 }, { opacity: 1, duration: 1.5 }, 0);
            tl.fromTo('.herohome-bg', { scale: 1.15 }, { scale: 1, duration: 2, ease: 'power2.out' }, 0);

            tl.from('.herohome-g-hero-line', {
                y: 100,
                opacity: 0,
                stagger: 0.15,
            }, 0.5);

            tl.from(['.herohome-g-stats', '.herohome-g-bottom-right', '.herohome-g-book-btn'], {
                opacity: 0,
                y: 20,
                stagger: 0.1,
            }, 1);

        });
    </script>

</body>
</html>
