<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Floracion Premium Stays</title>
    
    <script src="https://cdn.tailwindcss.com"></script>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Roboto:wght@400&display=swap" rel="stylesheet">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <style>
        /* Using Roboto as the base font for the body */
        body {
            font-family: 'Roboto', sans-serif;
            color: #1f2937; 
            background-color: #ffffff;
        }

        /* --- PRELOADER STYLES --- */
        #preloader {
            font-family: 'Playfair Display', serif; /* Stylish font for preloader */
        }
        
        /* Prepares the individual letters for animation */
        #preloader-title span {
            display: inline-block; /* Allows transforms like translateY */
            opacity: 0;
            transform: translateY(40px);
        }

    </style>
</head>
<body>

    <div id="preloader" class="fixed inset-0 bg-white z-50 flex flex-col justify-center items-center">
        <div class="text-center">
            <h1 id="preloader-title" class="text-4xl md:text-6xl font-bold text-gray-800 tracking-wider"></h1>
            <p id="preloader-subtitle" class="text-lg text-gray-600 mt-4 opacity-0 font-sans">
                Welcome to Floracion
            </p>
        </div>
    </div>

    <div id="main-container" class="opacity-0"> <main>
            <?php
                // Your PHP includes remain the same
                require 'navbar.php'; 
                require 'hero.php';
                require 'AboutPreview.php';
                require 'WhatWeOffer.php';
                require 'available_properties.php';
                require 'MoreInfoPage.php';
                require 'cta.php';
                require 'LandingPage.php';
                require 'Footer.php';
            ?>
            <div class="h-screen bg-gray-200 flex justify-center items-center text-4xl">Hero Section</div>
            <div class="h-screen bg-white flex justify-center items-center text-4xl about-section">About Section</div>
            <div class="h-screen bg-gray-200 flex justify-center items-center text-4xl offer-section">Offer Section</div>
            <div class="h-screen bg-white flex justify-center items-center text-4xl cta-section">CTA Section</div>

        </main>
    </div>
    
    <a href="https://wa.me/918971029884" target="_blank" rel="noopener noreferrer" class="fixed bottom-6 right-6 z-40 flex items-center justify-center bg-[#25D366] text-white py-3 px-4 rounded-full shadow-xl hover:bg-[#128C7E] transition-colors duration-300 transform hover:scale-105">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
            <path d="M.057 24l1.687-6.163c-1.041-1.804-1.588-3.849-1.587-5.946.003-6.556 5.338-11.891 11.893-11.891 3.181.001 6.167 1.24 8.413 3.488 2.245 2.248 3.481 5.236 3.48 8.414-.003 6.557-5.338 11.892-11.894 11.892-1.99-.001-3.951-.5-5.688-1.448l-6.305 1.654zm6.597-3.807c1.676.995 3.276 1.591 5.392 1.592 5.448 0 9.886-4.434 9.889-9.885.002-5.462-4.415-9.89-9.881-9.892-5.452 0-9.887 4.434-9.889 9.886-.001 2.225.651 3.891 1.746 5.634l-.999 3.648 3.742-.981zm11.387-5.464c-.074-.124-.272-.198-.57-.347-.297-.149-1.758-.868-2.031-.967-.272-.099-.47-.149-.669.149-.198.297-.768.967-.941 1.165-.173.198-.347.223-.644.074-.297-.149-1.255-.462-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.297-.347.446-.521.151-.172.2-.296.3-.495.099-.198.05-.371-.025-.521-.075-.148-.669-1.611-.916-2.206-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01s-.521.074-.794.371c-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.626.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.695.248-1.29.173-1.414z"/>
        </svg>
        <span class="ml-3 hidden md:inline-block font-semibold text-base">Chat with us</span>
    </a>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
           
            gsap.registerPlugin(ScrollTrigger);
            window.scrollTo(0, 0); // Start at top of the page

            // --- PRELOADER ANIMATION ---
            const preloaderTitle = document.getElementById('preloader-title');
            const text = "FLORACION";
            
            // Inject letters into the title wrapped in spans
            text.split('').forEach(char => {
                const span = document.createElement('span');
                span.textContent = char;
                preloaderTitle.appendChild(span);
            });
            
            // Animation for preloader text appearing
            const preloaderTl = gsap.timeline();
            preloaderTl.to('#preloader-title span', {
                opacity: 1,
                y: 0,
                stagger: 0.1,
                ease: 'power3.out',
                duration: 1
            }).to('#preloader-subtitle', {
                opacity: 1,
                duration: 2,
                ease: 'power2.inOut'
            }, "-=0.6"); // Start this animation slightly before the title finishes

            // --- FADE OUT PRELOADER & FADE IN SITE ---
            window.onload = () => {
                const outroTl = gsap.timeline({
                    onComplete: () => {
                         // After animation, hide preloader to prevent interaction
                        document.getElementById('preloader').style.display = 'none';
                    }
                });
                outroTl.to('#preloader', {
                    opacity: 0,
                    duration: 2.5,
                    ease: 'power3.inOut'
                }).to('#main-container', {
                    opacity: 1,
                    duration: 1,
                    ease: 'power3.inOut'
                }, "-=0.8"); // Start fading in site while preloader is still fading out
            };


            // --- GSAP PAGE SCROLL ANIMATIONS ---
            
            // Wait a bit before initializing scroll animations to ensure smooth transition
            setTimeout(() => {
                // 1. Hero Section Animation (assuming it's part of your Hero.php)
                // If your hero section has these classes, this will work.
                const heroTl = gsap.timeline({ defaults: { ease: 'power3.out', duration: 1 } });
                heroTl.from('.g-title', { opacity: 0, y: 50, delay: 0.2 })
                      .from('.g-subtitle', { opacity: 0, y: 40 }, "-=0.8")
                      .from('.g-button', { opacity: 0, y: 30, stagger: 0.2 }, "-=0.6");

                // 2. About Section Animation
                gsap.from('.about-image-container', { 
                    x: -100, 
                    opacity: 0, 
                    duration: 1.2, 
                    scrollTrigger: { trigger: '.about-section', start: 'top 70%' } 
                });
                gsap.from('.about-content > *', { 
                    x: 100, 
                    opacity: 0, 
                    stagger: 0.2, 
                    scrollTrigger: { trigger: '.about-section', start: 'top 70%' } 
                });

                // 3. "What We Offer" Section Animation
                gsap.from('.offer-title', { 
                    y: 50, 
                    opacity: 0, 
                    scrollTrigger: { trigger: '.offer-section', start: 'top 80%' } 
                });
                gsap.from('.offer-card', { 
                    y: 100, 
                    opacity: 0, 
                    stagger: 0.2, 
                    duration: 0.8, 
                    scrollTrigger: { trigger: '.offer-section', start: 'top 70%' } 
                });
                
                // 4. CTA Section Animation
                gsap.from('.cta-section > *', {
                    opacity: 0,
                    y: 50,
                    stagger: 0.3,
                    scrollTrigger: { trigger: '.cta-section', start: 'top 80%' }
                });

            }, 500); // Small delay to prevent conflict with preloader animation
        });
    </script>

</body>
</html>