<?php
// Start the session at the very beginning
session_start(); 

// If user is already logged in, redirect to index
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("location: property_details.php");
    exit;
}

// Include the database connection file
include 'config/db.php';

$message = "";

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Sanitize user input
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $pass = mysqli_real_escape_string($conn, $_POST['password']);

    // SQL to find the user
    // WARNING: Comparing plain text passwords is very insecure.
    $sql = "SELECT id, name FROM users WHERE email = '$email' AND password = '$pass'";
    $result = $conn->query($sql);

    if ($result->num_rows == 1) {
        // User found, fetch data and start session
        $user = $result->fetch_assoc();
        $_SESSION['loggedin'] = true;
        $_SESSION['userid'] = $user['id'];
        $_SESSION['name'] = $user['name'];

        // Redirect to a welcome/index page
        header("location: property_details.php");
        exit;
    } else {
        // User not found or incorrect password
        $message = "Invalid email or password. Please try again.";
    }

    // Close the database connection
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Grand Hotels</title>
    
    <!-- External Libraries -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"/>
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom Styles Included -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .backdrop-blur-lg {
            backdrop-filter: blur(10px);
        }
    </style>
</head>
<body class="bg-gray-100">

    <div class="min-h-screen flex items-center justify-center bg-cover bg-center" style="background-image: url('https://images.unsplash.com/photo-1562778612-e1e073d299d8?q=80&w=1974&auto=format&fit=crop');">
        <div class="container mx-auto p-4">
            <div class="max-w-4xl mx-auto bg-white bg-opacity-80 backdrop-blur-lg rounded-2xl shadow-2xl overflow-hidden">
                <div class="grid grid-cols-1 md:grid-cols-2">
                    
                    <!-- Left Side: Login Form -->
                    <div class="p-8 md:p-12 order-2 md:order-1" data-aos="fade-right" data-aos-delay="200">
                        <h2 class="text-3xl font-bold text-gray-800 mb-1 flex items-center">
                            <i class="fas fa-sign-in-alt mr-3 text-teal-500"></i>
                            Secure Login
                        </h2>
                        <p class="text-gray-600 mb-6">Welcome back! Please enter your details.</p>
                        
                        <?php if(!empty($message)): ?>
                            <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-100" role="alert">
                                <?php echo $message; ?>
                            </div>
                        <?php endif; ?>

                        <form action="login.php" method="POST" class="space-y-4">
                            <div class="relative">
                                <i class="fa fa-envelope absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="email" name="email" placeholder="Email Address" class="w-full py-3 pl-12 pr-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-teal-500 focus:border-transparent transition" required>
                            </div>
                            <div class="relative">
                                <i class="fa fa-lock absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="password" name="password" placeholder="Password" class="w-full py-3 pl-12 pr-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-teal-500 focus:border-transparent transition" required>
                            </div>
                            <button type="submit" class="w-full bg-teal-500 text-white py-3 rounded-lg font-semibold hover:bg-teal-600 transition-transform transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-teal-500 shadow-lg">
                                Login Securely <i class="fas fa-arrow-right ml-2"></i>
                            </button>
                        </form>

                        <p class="text-center text-gray-600 mt-6">
                            Don't have an account? <a href="register.php" class="text-teal-500 hover:underline font-semibold">Register here</a>
                        </p>
                    </div>

                    <!-- Right Side: Vector Image & Welcome Text -->
                    <div class="p-8 md:p-12 bg-teal-600/80 text-white flex flex-col justify-center items-center order-1 md:order-2 text-center" data-aos="fade-left">
                         <div class="w-40 h-40 mb-6" id="vector-container">
                           <!-- SVG Vector for Security -->
                           <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-full h-full"><path fill-rule="evenodd" d="M12 1.5a5.25 5.25 0 00-5.25 5.25v3a3 3 0 00-3 3v6.75a3 3 0 003 3h10.5a3 3 0 003-3v-6.75a3 3 0 00-3-3v-3c0-2.9-2.35-5.25-5.25-5.25zm3.75 8.25v-3a3.75 3.75 0 10-7.5 0v3h7.5z" clip-rule="evenodd"></path></svg>
                        </div>
                        <h2 class="text-3xl font-bold mb-2" id="welcome-text">Welcome Back!</h2>
                        <p id="welcome-subtext">Your next great stay is just a login away.</p>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- JS Libraries -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js"></script>
    <script>
        // Initialize AOS
        AOS.init({
            duration: 800,
            once: true,
        });

        // GSAP Animations
        gsap.from("#vector-container", { duration: 1.5, scale: 0.5, opacity: 0, ease: "elastic.out(1, 0.4)", delay: 0.2 });
        gsap.from("#welcome-text", { duration: 1, y: -50, opacity: 0, ease: "power2.out", delay: 0.5 });
        gsap.from("#welcome-subtext", { duration: 1, y: 50, opacity: 0, ease: "power2.out", delay: 0.7 });
    </script>
</body>
</html>
