<?php
// Safely start the session only if one isn't already active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FLORACION</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"/>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
</head>
<body>

<header id="main-header" class="fixed top-0 left-0 w-full z-50 transition-all duration-300 ease-in-out bg-transparent">
    <div class="container mx-auto px-4 sm:px-6 py-4 flex justify-between items-center">
        <a href="index.php">
            <img id="logo-img" src="assets/logo.png" alt="FLORACION Logo" class="h-10 md:h-12 object-contain transition-all duration-300 brightness-0 invert" />
        </a>
        <nav class="hidden lg:flex items-center gap-8">
            <a href="index.php" class="text-sm font-medium tracking-wider uppercase text-white hover:text-gray-300 transition-colors <?php if($currentPage == 'index.php') echo 'font-bold'; ?>">Home</a>
            <a href="About.php" class="text-sm font-medium tracking-wider uppercase text-white hover:text-gray-300 transition-colors <?php if($currentPage == 'About.php') echo 'font-bold'; ?>">About</a>
            <a href="Contact.php" class="text-sm font-medium tracking-wider uppercase text-white hover:text-gray-300 transition-colors <?php if($currentPage == 'Contact.php') echo 'font-bold'; ?>">Contact</a>
        </nav>
        <div class="flex items-center gap-4">
            
            <!-- == EXPANDING SEARCH BAR SECTION == -->
            <div class="hidden lg:block">
                <form action="search.php" method="GET" id="desktop-search-form" class="flex items-center bg-white/20 rounded-full transition-all duration-300 ease-in-out">
                    <input type="text" name="location" placeholder="Search by city..." id="desktop-search-input" class="w-40 p-2 pl-4 text-sm text-white bg-transparent focus:outline-none placeholder-gray-300">
                    <button type="submit" id="desktop-search-button" class="p-2 text-white hover:text-gray-300 transition-colors">
                        <svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="20px" width="20px" xmlns="http://www.w3.org/2000/svg"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                    </button>
                </form>
            </div>
            <!-- == END EXPANDING SEARCH BAR SECTION == -->

            <!-- == USER ICON AND NAME SECTION == -->
            <div class="hidden lg:flex items-center gap-3">
                <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true): ?>
                    <a href="my_bookings.php" class="flex items-center gap-2 text-white hover:text-gray-300 transition-colors">
                        <i class="fa-solid fa-circle-user text-2xl"></i>
                        <span class="text-sm font-medium tracking-wider uppercase"><?php echo htmlspecialchars($_SESSION['name']); ?></span>
                    </a>
                    <span class="text-gray-500">|</span>
                    <a href="logout.php" class="text-sm font-medium tracking-wider uppercase text-white hover:text-gray-300 transition-colors">Logout</a>
                <?php else: ?>
                    <a href="login.php" class="text-sm font-medium tracking-wider uppercase text-white hover:text-gray-300 transition-colors">Login</a>
                <?php endif; ?>
            </div>
            <!-- == END USER SECTION == -->

            <div class="lg:hidden">
                <button id="menu-toggle-btn" aria-label="Toggle Menu" class="z-50 relative text-white">
                    <svg id="menu-open-icon" stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="28px" width="28px" xmlns="http://www.w3.org/2000/svg"><line x1="3" y1="12" x2="21" y2="12"></line><line x1="3" y1="6" x2="21" y2="6"></line><line x1="3" y1="18" x2="21" y2="18"></line></svg>
                    <svg id="menu-close-icon" class="hidden" stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" height="28px" width="28px" xmlns="http://www.w3.org/2000/svg"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                </button>
            </div>
        </div>
    </div>
</header>
<div id="mobile-menu" class="lg:hidden fixed top-0 left-0 w-full h-full bg-white z-40" style="transform: translateX(100%);">
    <nav class="flex flex-col items-center justify-center h-full gap-8">
        <a href="index.php" class="mobile-nav-link text-2xl <?php echo ($currentPage == 'index.php') ? 'text-emerald-600 font-bold' : 'text-gray-800 hover:text-emerald-600'; ?>">Home</a>
        <a href="About.php" class="mobile-nav-link text-2xl <?php echo ($currentPage == 'About.php') ? 'text-emerald-600 font-bold' : 'text-gray-800 hover:text-emerald-600'; ?>">About</a>
        <a href="Contact.php" class="mobile-nav-link text-2xl <?php echo ($currentPage == 'Contact.php') ? 'text-emerald-600 font-bold' : 'text-gray-800 hover:text-emerald-600'; ?>">Contact</a>
        
        <div class="w-full px-8 mt-4">
            <form action="search.php" method="GET" class="w-full flex items-center gap-2 bg-gray-100 rounded-full p-1 border-2 border-transparent focus-within:border-emerald-600 transition-colors">
                <input type="text" name="location" placeholder="Search by city..." class="w-full py-2 px-4 bg-transparent text-gray-800 focus:outline-none">
                <button type="submit" class="flex-shrink-0 text-white bg-emerald-600 rounded-full p-2 hover:bg-emerald-700 transition-colors">
                    <svg class="w-4 h-4" stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" xmlns="http://www.w3.org/2000/svg"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                </button>
            </form>
        </div>

        <div class="mt-8 border-t border-gray-200 pt-8 w-full flex flex-col items-center gap-4">
            <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true): ?>
                <div class="flex items-center gap-3 text-gray-800">
                    <i class="fa-solid fa-circle-user text-3xl"></i>
                    <span class="text-xl font-bold"><?php echo htmlspecialchars($_SESSION['name']); ?></span>
                </div>
                <a href="my_bookings.php" class="text-xl text-gray-800 hover:text-emerald-600 font-medium">My Bookings</a>
                <a href="logout.php" class="text-xl text-red-500 hover:text-red-700 font-medium">Logout</a>
            <?php else: ?>
                <a href="login.php" class="text-2xl text-gray-800 hover:text-emerald-600 font-bold">Login / Register</a>
            <?php endif; ?>
        </div>
    </nav>
</div>

<style>
#main-header.scrolled { background-color: #111827; box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1); }
#main-header.scrolled #desktop-search-form { background-color: rgba(255, 255, 255, 0.1); }
#menu-toggle-btn.menu-is-open { color: #1f2937; }
</style>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const header = document.getElementById('main-header');
    const menuToggleBtn = document.getElementById('menu-toggle-btn');
    const mobileMenu = document.getElementById('mobile-menu');
    const menuOpenIcon = document.getElementById('menu-open-icon');
    const menuCloseIcon = document.getElementById('menu-close-icon');
    let isMenuOpen = false;
    const handleScroll = () => { if (window.scrollY > 20) { header.classList.add('scrolled'); } else { header.classList.remove('scrolled'); } };
    window.addEventListener('scroll', handleScroll, { passive: true });
    const toggleMenu = () => {
        isMenuOpen = !isMenuOpen;
        gsap.to(mobileMenu, { x: isMenuOpen ? '0%' : '100%', duration: 0.5, ease: 'power3.inOut' });
        document.body.style.overflow = isMenuOpen ? 'hidden' : 'unset';
        menuOpenIcon.classList.toggle('hidden', isMenuOpen);
        menuCloseIcon.classList.toggle('hidden', !isMenuOpen);
        menuToggleBtn.classList.toggle('menu-is-open', isMenuOpen);
    };
    menuToggleBtn.addEventListener('click', toggleMenu);
});
</script>

</body>
</html>
