<?php // FILE: login.php (Updated) ?>
<?php
// Start the session at the very beginning.
session_start();

// If user is already logged in, redirect to the dashboard
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
    header("location: index.php");
    exit;
}

// Include the database connection file.
// Make sure the path is correct. If db.php is in the same folder, use "db.php".
// If it's in a parent 'config' folder, use "../config/db.php".
require_once "../config/db.php"; 

// Initialize variables for feedback
$feedback_message = "";
$feedback_class = "";

// Check if the form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Sanitize user input to prevent SQL injection
    $email = mysqli_real_escape_string($link, $_POST['email']);
    $password = mysqli_real_escape_string($link, $_POST['password']);

    // Prepare the SQL statement to prevent SQL injection
    $sql = "SELECT id, name, email FROM owners WHERE email = ? AND password = ? AND status = 'approved'";

    if ($stmt = mysqli_prepare($link, $sql)) {
        mysqli_stmt_bind_param($stmt, "ss", $email, $password);

        if (mysqli_stmt_execute($stmt)) {
            mysqli_stmt_store_result($stmt);

            if (mysqli_stmt_num_rows($stmt) == 1) {
                mysqli_stmt_bind_result($stmt, $id, $name, $email);
                if (mysqli_stmt_fetch($stmt)) {
                    // Store data in session variables
                    $_SESSION["loggedin"] = true;
                    $_SESSION["id"] = $id;
                    $_SESSION["name"] = $name;

                    // *** REDIRECT TO DASHBOARD ON SUCCESS ***
                    header("location: index.php");
                    exit; // Crucial to stop script execution after redirect
                }
            } else {
                $feedback_message = "Invalid credentials or your account is not yet approved.";
                $feedback_class = "text-red-500";
            }
        } else {
            $feedback_message = "Oops! Something went wrong. Please try again later.";
            $feedback_class = "text-red-500";
        }
        mysqli_stmt_close($stmt);
    }
    mysqli_close($link);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Owner Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-image: url('https://images.unsplash.com/photo-1488330890490-c291ecf62571?q=80&w=2070&auto=format&fit=crop');
            background-size: cover;
            background-position: center;
        }
        .login-container { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); }
    </style>
</head>
<body class="text-gray-800">
    <div class="min-h-screen flex items-center justify-center p-4">
        <div class="w-full max-w-5xl lg:grid lg:grid-cols-2 shadow-2xl rounded-2xl overflow-hidden login-container" data-aos="zoom-in">
            <div class="hidden lg:flex items-center justify-center p-12 bg-cyan-600/10">
                <img src="https://storage.googleapis.com/proudcity/mebanenc/uploads/2021/03/placeholder-image.png" alt="Illustration" class="w-full h-auto object-cover">
            </div>
            <div class="p-8 md:p-12">
                <div class="text-center mb-8">
                    <i data-lucide="log-in" class="mx-auto h-12 w-12 text-cyan-600"></i>
                    <h1 class="text-3xl font-bold text-gray-800 mt-4">Owner Login</h1>
                    <p class="text-gray-500 mt-2">Sign in to access your dashboard.</p>
                </div>
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="space-y-6">
                    <div class="relative">
                        <i data-lucide="mail" class="absolute top-1/2 -translate-y-1/2 left-4 text-gray-400"></i>
                        <input type="email" name="email" placeholder="Email Address" class="w-full bg-gray-100 border-2 border-gray-200 rounded-full py-3 px-12 text-gray-700 focus:outline-none focus:border-cyan-500" required>
                    </div>
                    <div class="relative">
                        <i data-lucide="lock" class="absolute top-1/2 -translate-y-1/2 left-4 text-gray-400"></i>
                        <input type="password" name="password" placeholder="Password" class="w-full bg-gray-100 border-2 border-gray-200 rounded-full py-3 px-12 text-gray-700 focus:outline-none focus:border-cyan-500" required>
                    </div>
                    <?php if(!empty($feedback_message)): ?>
                        <div class="text-center font-semibold <?php echo $feedback_class; ?>"><?php echo $feedback_message; ?></div>
                    <?php endif; ?>
                    <div>
                        <button type="submit" class="w-full bg-cyan-600 hover:bg-cyan-700 text-white font-bold py-3 px-4 rounded-full transition-all">Login Securely</button>
                    </div>
                </form>
                <div class="mt-8 text-center text-sm text-gray-500">
                    <p>Don't have an account? <a href="owner_reg.php" class="font-medium text-cyan-600 hover:text-cyan-700">Register here</a></p>
                </div>
            </div>
        </div>
    </div>
    <script> AOS.init(); lucide.createIcons(); </script>
</body>
</html>
