<?php // FILE: db.php ?>
<?php
include '../config/db.php'
?>


<?php // FILE: register.php ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Owner Registration</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
        body { font-family: 'Inter', sans-serif; background-color: #111827; }
        .glassmorphism { background: rgba(255, 255, 255, 0.05); backdrop-filter: blur(12px); -webkit-backdrop-filter: blur(12px); border: 1px solid rgba(255, 255, 255, 0.1); }
    </style>
</head>
<body class="text-white">

<?php
// --- PHP BACKEND LOGIC ---

// Include the database connection file
require_once "../config/db.php";

// Initialize variables for feedback
$feedback_message = "";
$feedback_class = "";

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
    
    // --- FORM PROCESSING ---
    $name = mysqli_real_escape_string($link, $_POST['name']);
    $email = mysqli_real_escape_string($link, $_POST['email']);
    $password = mysqli_real_escape_string($link, $_POST['password']); // Storing plain text password as requested
    $location = mysqli_real_escape_string($link, $_POST['location']);
    $contact = mysqli_real_escape_string($link, $_POST['contact']);

    // Check if email already exists
    $sql_check = "SELECT id FROM owners WHERE email = ?";
    if($stmt_check = mysqli_prepare($link, $sql_check)){
        mysqli_stmt_bind_param($stmt_check, "s", $email);
        mysqli_stmt_execute($stmt_check);
        mysqli_stmt_store_result($stmt_check);
        
        if(mysqli_stmt_num_rows($stmt_check) > 0){
            $feedback_message = "This email address is already registered.";
            $feedback_class = "text-red-400";
        } else {
            // Prepare an insert statement
            $sql = "INSERT INTO owners (name, email, password, location, contact) VALUES (?, ?, ?, ?, ?)";
            
            if($stmt = mysqli_prepare($link, $sql)){
                mysqli_stmt_bind_param($stmt, "sssss", $name, $email, $password, $location, $contact);
                
                if(mysqli_stmt_execute($stmt)){
                    $feedback_message = "Registration successful! An admin will review your application.";
                    $feedback_class = "text-green-400";
                } else{
                    $feedback_message = "Oops! Something went wrong. Please try again.";
                    $feedback_class = "text-red-400";
                }
                mysqli_stmt_close($stmt);
            }
        }
        mysqli_stmt_close($stmt_check);
    }
    mysqli_close($link);
}
?>

    <div class="container mx-auto p-4 min-h-screen flex items-center justify-center">
        <div class="max-w-2xl w-full" data-aos="fade-up">
            <div class="glassmorphism rounded-2xl p-8 shadow-2xl">
                <div class="text-center mb-8">
                    <h1 class="text-4xl font-bold text-cyan-300">Owner Registration</h1>
                    <p class="text-gray-400 mt-2">Create your account to join our platform.</p>
                </div>
                <form id="owner-registration-form" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="space-y-6">
                    <div class="relative form-field">
                        <i data-lucide="user" class="absolute top-1/2 -translate-y-1/2 left-3 text-gray-400"></i>
                        <input type="text" id="name" name="name" placeholder="Full Name" class="w-full bg-gray-800 border-2 border-gray-700 rounded-lg py-3 px-10 text-white focus:outline-none focus:border-cyan-500 transition-colors duration-300" required>
                    </div>
                    <div class="relative form-field">
                        <i data-lucide="mail" class="absolute top-1/2 -translate-y-1/2 left-3 text-gray-400"></i>
                        <input type="email" id="email" name="email" placeholder="Email Address" class="w-full bg-gray-800 border-2 border-gray-700 rounded-lg py-3 px-10 text-white focus:outline-none focus:border-cyan-500 transition-colors duration-300" required>
                    </div>
                    <div class="relative form-field">
                        <i data-lucide="lock" class="absolute top-1/2 -translate-y-1/2 left-3 text-gray-400"></i>
                        <input type="password" id="password" name="password" placeholder="Password" class="w-full bg-gray-800 border-2 border-gray-700 rounded-lg py-3 px-10 text-white focus:outline-none focus:border-cyan-500 transition-colors duration-300" required>
                    </div>
                    <div class="relative form-field">
                        <i data-lucide="map-pin" class="absolute top-1/2 -translate-y-1/2 left-3 text-gray-400"></i>
                        <input type="text" id="location" name="location" placeholder="Location" class="w-full bg-gray-800 border-2 border-gray-700 rounded-lg py-3 px-10 text-white focus:outline-none focus:border-cyan-500 transition-colors duration-300" required>
                    </div>
                    <div class="relative form-field">
                        <i data-lucide="phone" class="absolute top-1/2 -translate-y-1/2 left-3 text-gray-400"></i>
                        <input type="tel" id="contact" name="contact" placeholder="Contact Number" class="w-full bg-gray-800 border-2 border-gray-700 rounded-lg py-3 px-10 text-white focus:outline-none focus:border-cyan-500 transition-colors duration-300" required>
                    </div>
                    <button type="submit" class="w-full bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 px-4 rounded-lg transition-transform duration-300 transform hover:scale-105 shadow-lg shadow-cyan-500/20">Register Now</button>
                </form>
                <?php if(!empty($feedback_message)): ?>
                    <div id="feedback-message" class="mt-6 text-center font-semibold <?php echo $feedback_class; ?>">
                        <?php echo $feedback_message; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        AOS.init({ duration: 800, once: true });
        lucide.createIcons();

        gsap.from(".form-field", {
            duration: 0.7,
            opacity: 0,
            y: 30,
            stagger: 0.15,
            ease: "power2.out",
            delay: 0.5
        });

        <?php if(!empty($feedback_message)): ?>
        gsap.fromTo("#feedback-message", {opacity: 0, y: 20}, {opacity: 1, y: 0, duration: 0.5, delay: 0.2});
        <?php endif; ?>
    </script>
</body>
</html>

