<?php
// Include the database connection file
include 'config/db.php';

// Create a variable to store messages
$message = "";
$message_type = ""; // To control alert color (e.g., 'success' or 'error')

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Sanitize user input to prevent SQL injection
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $contact = mysqli_real_escape_string($conn, $_POST['contact']);
    // Storing password as plain text as requested.
    // WARNING: This is highly insecure. In a real-world application, ALWAYS hash passwords.
    $pass = mysqli_real_escape_string($conn, $_POST['password']);

    // Check if email already exists
    $check_email_sql = "SELECT * FROM users WHERE email = '$email'";
    $result = $conn->query($check_email_sql);

    if ($result->num_rows > 0) {
        $message = "An account with this email already exists.";
        $message_type = "error";
    } else {
        // SQL to insert new user
        $sql = "INSERT INTO users (name, email, contact, password) VALUES ('$name', '$email', '$contact', '$pass')";

        if ($conn->query($sql) === TRUE) {
            $message = "Registration successful! You can now <a href='login.php' class='font-bold underline'>login</a>.";
            $message_type = "success";
        } else {
            $message = "Error: " . $sql . "<br>" . $conn->error;
            $message_type = "error";
        }
    }

    // Close the database connection
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Grand Hotels</title>
    
    <!-- External Libraries -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"/>
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom Styles Included -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .backdrop-blur-lg {
            backdrop-filter: blur(10px);
        }
    </style>
</head>
<body class="bg-gray-100">

    <div class="min-h-screen flex items-center justify-center bg-cover bg-center" style="background-image: url('https://images.unsplash.com/photo-1445019980597-93e0901b8965?q=80&w=2070&auto=format&fit=crop');">
        <div class="container mx-auto p-4">
            <div class="max-w-4xl mx-auto bg-white bg-opacity-80 backdrop-blur-lg rounded-2xl shadow-2xl overflow-hidden">
                <div class="grid grid-cols-1 md:grid-cols-2">
                    
                    <!-- Left Side: Vector Image & Welcome Text -->
                    <div class="p-8 md:p-12 bg-teal-600/80 text-white flex flex-col justify-center items-center text-center" data-aos="fade-right">
                        <div class="w-40 h-40 mb-6" id="vector-container">
                           <!-- SVG Vector for Travel -->
                           <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-full h-full"><path d="M12.378 1.602a.75.75 0 00-.756 0L3 6.632l9 5.25 9-5.25-8.622-5.03zM21.75 7.93l-9 5.25v9l8.628-5.034a.75.75 0 00.372-.648V7.93zM11.25 22.18v-9l-9-5.25v8.57a.75.75 0 00.372.648l8.628 5.034z"></path></svg>
                        </div>
                        <h2 class="text-3xl font-bold mb-2" id="welcome-text">Join Our Exclusive Club</h2>
                        <p id="welcome-subtext">Sign up to unlock premium hotel deals and experiences.</p>
                    </div>

                    <!-- Right Side: Registration Form -->
                    <div class="p-8 md:p-12" data-aos="fade-left" data-aos-delay="200">
                        <h2 class="text-3xl font-bold text-gray-800 mb-1 flex items-center">
                            <i class="fas fa-user-plus mr-3 text-teal-500"></i>
                            Create Your Account
                        </h2>
                        <p class="text-gray-600 mb-6">It's free and only takes a minute.</p>
                        
                        <?php if(!empty($message)): ?>
                            <div class="p-4 mb-4 text-sm rounded-lg <?php echo ($message_type == 'success') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>" role="alert">
                                <?php echo $message; ?>
                            </div>
                        <?php endif; ?>

                        <form action="register.php" method="POST" class="space-y-4">
                            <div class="relative">
                                <i class="fa fa-user absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="text" name="name" placeholder="Full Name" class="w-full py-3 pl-12 pr-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-teal-500 focus:border-transparent transition" required>
                            </div>
                            <div class="relative">
                                <i class="fa fa-envelope absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="email" name="email" placeholder="Email Address" class="w-full py-3 pl-12 pr-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-teal-500 focus:border-transparent transition" required>
                            </div>
                            <div class="relative">
                                <i class="fa fa-phone absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="tel" name="contact" placeholder="Contact Number" class="w-full py-3 pl-12 pr-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-teal-500 focus:border-transparent transition" required>
                            </div>
                            <div class="relative">
                                <i class="fa fa-lock absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="password" name="password" placeholder="Password" class="w-full py-3 pl-12 pr-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-teal-500 focus:border-transparent transition" required>
                            </div>
                            <button type="submit" class="w-full bg-teal-500 text-white py-3 rounded-lg font-semibold hover:bg-teal-600 transition-transform transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-teal-500 shadow-lg">
                                Register Now <i class="fas fa-arrow-right ml-2"></i>
                            </button>
                        </form>

                        <p class="text-center text-gray-600 mt-6">
                            Already have an account? <a href="login.php" class="text-teal-500 hover:underline font-semibold">Login here</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JS Libraries -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.9.1/gsap.min.js"></script>
    <script>
        // Initialize AOS
        AOS.init({
            duration: 800,
            once: true,
        });

        // GSAP Animations
        gsap.from("#vector-container", { duration: 1.5, scale: 0.5, opacity: 0, ease: "elastic.out(1, 0.4)", delay: 0.2 });
        gsap.from("#welcome-text", { duration: 1, y: -50, opacity: 0, ease: "power2.out", delay: 0.5 });
        gsap.from("#welcome-subtext", { duration: 1, y: 50, opacity: 0, ease: "power2.out", delay: 0.7 });
    </script>
</body>
</html>
